/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.banconnector.api.model;

import ar.com.sdd.banconnector.api.model.CollectionItem;
import ar.com.sdd.banconnector.api.model.PayerReference;
import ar.com.sdd.banconnector.api.model.PaymentInstrument;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Payment
implements Serializable {
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ssXXX", timezone="GMT-03:00")
    private Date issueDateTime = null;
    private String accountReference = null;
    private String legalReference = null;
    private PayerReference payerReference = null;
    private String currencyCode = null;
    private BigDecimal totalAmount = null;
    private List<CollectionItem> collectionItems = new ArrayList<CollectionItem>();
    private List<PaymentInstrument> paymentInstruments = new ArrayList<PaymentInstrument>();

    @JsonProperty(value="issueDateTime")
    @NotNull
    public Date getIssueDateTime() {
        return this.issueDateTime;
    }

    public void setIssueDateTime(Date issueDateTime) {
        this.issueDateTime = issueDateTime;
    }

    @JsonProperty(value="accountReference")
    @NotNull
    @Size(max=255)
    public @NotNull @Size(max=255) String getAccountReference() {
        return this.accountReference;
    }

    public void setAccountReference(String accountReference) {
        this.accountReference = accountReference;
    }

    @JsonProperty(value="legalReference")
    @NotNull
    @Size(max=255)
    public @NotNull @Size(max=255) String getLegalReference() {
        return this.legalReference;
    }

    public void setLegalReference(String legalReference) {
        this.legalReference = legalReference;
    }

    @JsonProperty(value="payerReference")
    @NotNull
    public PayerReference getPayerReference() {
        return this.payerReference;
    }

    public void setPayerReference(PayerReference payerReference) {
        this.payerReference = payerReference;
    }

    @JsonProperty(value="currencyCode")
    @Size(max=3)
    public @Size(max=3) String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    @JsonProperty(value="totalAmount")
    @NotNull
    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    @JsonProperty(value="collectionItems")
    public List<CollectionItem> getCollectionItems() {
        return this.collectionItems;
    }

    public void setCollectionItems(List<CollectionItem> collectionItems) {
        this.collectionItems = collectionItems;
    }

    @JsonProperty(value="paymentInstruments")
    @NotNull
    public List<PaymentInstrument> getPaymentInstruments() {
        return this.paymentInstruments;
    }

    public void setPaymentInstruments(List<PaymentInstrument> paymentInstruments) {
        this.paymentInstruments = paymentInstruments;
    }

    public String toString() {
        return "Payment [" + (String)(this.issueDateTime != null ? "issueDateTime=" + this.issueDateTime + ", " : "") + (String)(this.accountReference != null ? "accountReference=" + this.accountReference + ", " : "") + (String)(this.legalReference != null ? "legalReference=" + this.legalReference + ", " : "") + (String)(this.payerReference != null ? "payerReference=" + this.payerReference + ", " : "") + (String)(this.currencyCode != null ? "currencyCode=" + this.currencyCode + ", " : "") + (String)(this.totalAmount != null ? "totalAmount=" + this.totalAmount + ", " : "") + (String)(this.collectionItems != null ? "collectionItems=" + Arrays.toString(this.collectionItems.toArray()) + ", " : "") + (String)(this.paymentInstruments != null ? "paymentInstruments=" + Arrays.toString(this.paymentInstruments.toArray()) : "") + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Payment payment = (Payment)o;
        if (this.issueDateTime != null ? !this.issueDateTime.equals(payment.issueDateTime) : payment.issueDateTime != null) {
            return false;
        }
        if (this.accountReference != null ? !this.accountReference.equals(payment.accountReference) : payment.accountReference != null) {
            return false;
        }
        if (this.legalReference != null ? !this.legalReference.equals(payment.legalReference) : payment.legalReference != null) {
            return false;
        }
        if (this.payerReference != null ? !this.payerReference.equals(payment.payerReference) : payment.payerReference != null) {
            return false;
        }
        if (this.currencyCode != null ? !this.currencyCode.equals(payment.currencyCode) : payment.currencyCode != null) {
            return false;
        }
        if (this.totalAmount != null ? !this.totalAmount.equals(payment.totalAmount) : payment.totalAmount != null) {
            return false;
        }
        if (this.collectionItems != null ? !this.collectionItems.equals(payment.collectionItems) : payment.collectionItems != null) {
            return false;
        }
        return this.paymentInstruments != null ? this.paymentInstruments.equals(payment.paymentInstruments) : payment.paymentInstruments == null;
    }

    public int hashCode() {
        int result = this.issueDateTime != null ? this.issueDateTime.hashCode() : 0;
        result = 31 * result + (this.accountReference != null ? this.accountReference.hashCode() : 0);
        result = 31 * result + (this.legalReference != null ? this.legalReference.hashCode() : 0);
        result = 31 * result + (this.payerReference != null ? this.payerReference.hashCode() : 0);
        result = 31 * result + (this.currencyCode != null ? this.currencyCode.hashCode() : 0);
        result = 31 * result + (this.totalAmount != null ? this.totalAmount.hashCode() : 0);
        result = 31 * result + (this.collectionItems != null ? this.collectionItems.hashCode() : 0);
        result = 31 * result + (this.paymentInstruments != null ? this.paymentInstruments.hashCode() : 0);
        return result;
    }
}

