package ar.com.sdd.banconnector.api.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Customer implements Serializable {

    private PayerReference payerReference = null;
    private String cuit = null;
    private String name = null;
    private String concept = null;
    private String address = null;
    private String city = null;
    private String state = null;
    private String zipCode = null;
    private String email = null;
    private List<BanconnectorEnum.InstructionCodesEnum> instructionCodes = new ArrayList<>();
    private BanconnectorEnum.TaxCodeEnum taxCode = null;
    private BanconnectorEnum.TaxCode2Enum taxCode2 = null;
    private String comments = null;
    private CustomerStatus customerStatus = null;

    public Customer() {

    }

    /**
     **/


    @JsonProperty("payerReference")
    public PayerReference getPayerReference() {
        return payerReference;
    }

    public void setPayerReference(PayerReference payerReference) {
        this.payerReference = payerReference;
    }

    /**
     * CUIT del cliente
     **/


    @JsonProperty("cuit")
    @Size(max = 11)
    public String getCuit() {
        return cuit;
    }

    public void setCuit(String cuit) {
        this.cuit = cuit;
    }

    /**
     * Razón social del pagador
     **/


    @JsonProperty("name")
    @Size(max = 255)
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    /**
     * Categorización del cliente dentro de la compañía
     **/


    @JsonProperty("concept")
    @Size(max = 255)
    public String getConcept() {
        return concept;
    }

    public void setConcept(String concept) {
        this.concept = concept;
    }

    /**
     * Dirección del pagador
     **/


    @JsonProperty("address")
    @Size(max = 255)
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    /**
     * Ciudad del pagador
     **/


    @JsonProperty("city")
    @Size(max = 100)
    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    /**
     * Estado o provincia del pagador
     **/


    @JsonProperty("state")
    @Size(max = 100)
    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    /**
     * Código postal del pagador
     **/


    @JsonProperty("zipCode")
    @Size(max = 100)
    public String getZipCode() {
        return zipCode;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    /**
     * Correo electrónico del pagador
     **/


    @JsonProperty("email")
    @Size(max = 150)
    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }



    /**
     * Formas de pago permitidas
     **/


    @JsonProperty("instructionCodes")
    public List<BanconnectorEnum.InstructionCodesEnum> getInstructionCodes() {
        return instructionCodes;
    }

    public void setInstructionCodes(List<BanconnectorEnum.InstructionCodesEnum> instructionCodes) {
        this.instructionCodes = instructionCodes;
    }

    /**
     * Condición de IVA del pagador. Segun Tipos de Responsables AFIP
     **/


    @JsonProperty("taxCode")
    public BanconnectorEnum.TaxCodeEnum getTaxCode() {
        return taxCode;
    }

    public void setTaxCode(BanconnectorEnum.TaxCodeEnum taxCode) {
        this.taxCode = taxCode;
    }

    /**
     * Condición de IIBB del pagador
     **/


    @JsonProperty("taxCode2")
    public BanconnectorEnum.TaxCode2Enum getTaxCode2() {
        return taxCode2;
    }

    public void setTaxCode2(BanconnectorEnum.TaxCode2Enum taxCode2) {
        this.taxCode2 = taxCode2;
    }

    /**
     * Texto libre
     **/


    @JsonProperty("comments")
    @Size(max = 200)
    public String getComments() {
        return comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    /**
     **/


    @JsonProperty("customerStatus")
    public CustomerStatus getCustomerStatus() {
        return customerStatus;
    }

    public void setCustomerStatus(CustomerStatus customerStatus) {
        this.customerStatus = customerStatus;
    }

    @Override
    public String toString() {
        return "Customer ["
                + ((payerReference != null) ? "payerReference=" + payerReference + ", " : "")
                + ((cuit != null) ? "cuit=" + cuit + ", " : "")
                + ((name != null) ? "name=" + name + ", " : "")
                + ((concept != null) ? "concept=" + concept + ", " : "")
                + ((address != null) ? "address=" + address + ", " : "")
                + ((city != null) ? "city=" + city + ", " : "")
                + ((state != null) ? "state=" + state + ", " : "")
                + ((zipCode != null) ? "zipCode=" + zipCode + ", " : "")
                + ((email != null) ? "email=" + email + ", " : "")
                + ((instructionCodes != null) ? "instructionCodes=" + Arrays.toString(instructionCodes.toArray()) + ", " : "")
                + ((taxCode != null) ? "taxCode=" + taxCode + ", " : "")
                + ((taxCode2 != null) ? "taxCode2=" + taxCode2 + ", " : "")
                + ((comments != null) ? "comments=" + comments + ", " : "")
                + ((customerStatus != null) ? "customerStatus=" + customerStatus : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Customer customer = (Customer) o;

        if (payerReference != null ? !payerReference.equals(customer.payerReference) : customer.payerReference != null) return false;
        if (cuit != null ? !cuit.equals(customer.cuit) : customer.cuit != null) return false;
        if (name != null ? !name.equals(customer.name) : customer.name != null) return false;
        if (concept != null ? !concept.equals(customer.concept) : customer.concept != null) return false;
        if (address != null ? !address.equals(customer.address) : customer.address != null) return false;
        if (city != null ? !city.equals(customer.city) : customer.city != null) return false;
        if (state != null ? !state.equals(customer.state) : customer.state != null) return false;
        if (zipCode != null ? !zipCode.equals(customer.zipCode) : customer.zipCode != null) return false;
        if (email != null ? !email.equals(customer.email) : customer.email != null) return false;
        if (instructionCodes != null ? !instructionCodes.equals(customer.instructionCodes) : customer.instructionCodes != null) return false;
        if (taxCode != customer.taxCode) return false;
        if (taxCode2 != customer.taxCode2) return false;
        if (comments != null ? !comments.equals(customer.comments) : customer.comments != null) return false;
        return customerStatus != null ? customerStatus.equals(customer.customerStatus) : customer.customerStatus == null;
    }

    @Override
    public int hashCode() {
        int result = payerReference != null ? payerReference.hashCode() : 0;
        result = 31 * result + (cuit != null ? cuit.hashCode() : 0);
        result = 31 * result + (name != null ? name.hashCode() : 0);
        result = 31 * result + (concept != null ? concept.hashCode() : 0);
        result = 31 * result + (address != null ? address.hashCode() : 0);
        result = 31 * result + (city != null ? city.hashCode() : 0);
        result = 31 * result + (state != null ? state.hashCode() : 0);
        result = 31 * result + (zipCode != null ? zipCode.hashCode() : 0);
        result = 31 * result + (email != null ? email.hashCode() : 0);
        result = 31 * result + (instructionCodes != null ? instructionCodes.hashCode() : 0);
        result = 31 * result + (taxCode != null ? taxCode.hashCode() : 0);
        result = 31 * result + (taxCode2 != null ? taxCode2.hashCode() : 0);
        result = 31 * result + (comments != null ? comments.hashCode() : 0);
        result = 31 * result + (customerStatus != null ? customerStatus.hashCode() : 0);
        return result;
    }
}

