package ar.com.sdd.banconnector.api.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import javax.validation.constraints.Size;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;


@JsonIgnoreProperties(ignoreUnknown = true)
public class DebitInstructionSet {

    private Long trackingNumber = null;
    private String ownerCuit = null;
    private String agreementCode = null;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date processDate = null;
    private List<DebitInstructionItem> debitInstructionItems = new ArrayList<DebitInstructionItem>();

    public DebitInstructionSet() {

    }

    /**
     * Número de seguimiento
     **/

    @JsonProperty("trackingNumber")
    public Long getTrackingNumber() {
        return trackingNumber;
    }

    public void setTrackingNumber(Long trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    /**
     * CUIT del propietario de las cuentas (sin guiones ni espacios)
     **/

    @JsonProperty("ownerCuit")
    @Size(max = 11)
    public String getOwnerCuit() {
        return ownerCuit;
    }

    public void setOwnerCuit(String ownerCuit) {
        this.ownerCuit = ownerCuit;
    }

    /**
     * Código de acuerdo
     **/

    @JsonProperty("agreementCode")
    @Size(max = 50)
    public String getAgreementCode() {
        return agreementCode;
    }

    public void setAgreementCode(String agreementCode) {
        this.agreementCode = agreementCode;
    }

    /**
     * Fecha de la publicación
     **/

    @JsonProperty("processDate")
    public Date getProcessDate() {
        return processDate;
    }

    public void setProcessDate(Date processDate) {
        this.processDate = processDate;
    }

    /**
     * Lista de instrucciones de débito a publicar
     **/

    @JsonProperty("debitInstructionItems")
    public List<DebitInstructionItem> getDebitInstructionItems() {
        return debitInstructionItems;
    }

    public void setDebitInstructionItems(List<DebitInstructionItem> debitInstructionItems) {
        this.debitInstructionItems = debitInstructionItems;
    }


    @Override
    public String toString() {
        return "DebitInstructionSet ["
                + ((trackingNumber != null) ? "trackingNumber=" + trackingNumber + ", " : "")
                + ((ownerCuit != null) ? "ownerCuit=" + ownerCuit + ", " : "")
                + ((agreementCode != null) ? "agreementCode=" + agreementCode + ", " : "")
                + ((processDate != null) ? "processDate=" + processDate + ", " : "")
                + ((debitInstructionItems != null) ? "debitInstructionItems=" + Arrays.toString(debitInstructionItems.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        DebitInstructionSet that = (DebitInstructionSet) o;

        if (trackingNumber != null ? !trackingNumber.equals(that.trackingNumber) : that.trackingNumber != null) return false;
        if (ownerCuit != null ? !ownerCuit.equals(that.ownerCuit) : that.ownerCuit != null) return false;
        if (agreementCode != null ? !agreementCode.equals(that.agreementCode) : that.agreementCode != null) return false;
        if (processDate != null ? !processDate.equals(that.processDate) : that.processDate != null) return false;
        return debitInstructionItems != null ? debitInstructionItems.equals(that.debitInstructionItems) : that.debitInstructionItems == null;
    }

    @Override
    public int hashCode() {
        int result = trackingNumber != null ? trackingNumber.hashCode() : 0;
        result = 31 * result + (ownerCuit != null ? ownerCuit.hashCode() : 0);
        result = 31 * result + (agreementCode != null ? agreementCode.hashCode() : 0);
        result = 31 * result + (processDate != null ? processDate.hashCode() : 0);
        result = 31 * result + (debitInstructionItems != null ? debitInstructionItems.hashCode() : 0);
        return result;
    }

}

