package ar.com.sdd.banconnector.api.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PaymentInstrumentImage implements Serializable {

    private String legalReference = null;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date issueDate = null;
    private List<Image> images = new ArrayList<Image>();

    public PaymentInstrumentImage() {

    }

    /**
     * Identificación del instrumento
     **/


    @JsonProperty("legalReference")
    @NotNull
    @Size(max = 255)
    public String getLegalReference() {
        return legalReference;
    }

    public void setLegalReference(String legalReference) {
        this.legalReference = legalReference;
    }

    /**
     * Fecha de emisión
     **/


    @JsonProperty("issueDate")
    @NotNull
    public Date getIssueDate() {
        return issueDate;
    }

    public void setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
    }

    /**
     * Imágenes en Base64
     **/


    @JsonProperty("images")
    @NotNull
    public List<Image> getImages() {
        return images;
    }

    public void setImages(List<Image> images) {
        this.images = images;
    }

    @Override
    public String toString() {
        return "PaymentInstrumentImage ["
                + ((legalReference != null) ? "legalReference=" + legalReference + ", " : "")
                + ((issueDate != null) ? "issueDate=" + issueDate + ", " : "")
                + ((images != null) ? "images=" + Arrays.toString(images.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        PaymentInstrumentImage that = (PaymentInstrumentImage) o;

        if (legalReference != null ? !legalReference.equals(that.legalReference) : that.legalReference != null) return false;
        if (issueDate != null ? !issueDate.equals(that.issueDate) : that.issueDate != null) return false;
        return images != null ? images.equals(that.images) : that.images == null;
    }

    @Override
    public int hashCode() {
        int result = legalReference != null ? legalReference.hashCode() : 0;
        result = 31 * result + (issueDate != null ? issueDate.hashCode() : 0);
        result = 31 * result + (images != null ? images.hashCode() : 0);
        return result;
    }
}

