/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.banconnector.api.util;

import ar.com.sdd.banconnector.api.util.JacksonConfig;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BanconnectorUtil {
    public static String getCacheSafeValue() {
        long ts = System.currentTimeMillis();
        return Long.toString(ts, 36);
    }

    public static String serializeToJsonString(Object object) throws JsonProcessingException {
        return BanconnectorUtil.serializeToJsonString(object, false);
    }

    public static String serializeToJsonString(Object object, boolean prettyPrint) throws JsonProcessingException {
        ObjectMapper mapper = JacksonConfig.getObjectMapper();
        if (prettyPrint) {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
        }
        return mapper.writeValueAsString(object);
    }

    public static void serializeToJsonOutputStream(Object object, OutputStream outputStream) throws IOException {
        BanconnectorUtil.serializeToJsonOutputStream(object, outputStream, false);
    }

    public static void serializeToJsonOutputStream(Object object, OutputStream outputStream, boolean prettyPrint) throws IOException {
        ObjectMapper mapper = JacksonConfig.getObjectMapper();
        if (prettyPrint) {
            mapper.writerWithDefaultPrettyPrinter().writeValue(outputStream, object);
        } else {
            mapper.writeValue(outputStream, object);
        }
    }

    public static <T> T deserializeFromJsonString(String json, Class<T> type) throws IOException {
        ObjectMapper mapper = JacksonConfig.getObjectMapper();
        return (T)mapper.readValue(json, type);
    }

    public static <T> T deserializeFromJsonInputStream(InputStream inputStream, Class<T> type) throws IOException {
        ObjectMapper mapper = JacksonConfig.getObjectMapper();
        return (T)mapper.readValue(inputStream, type);
    }
}

