package ar.com.sdd.bindapi.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class DeleteBajaCVUResponse implements Serializable {

    @JsonProperty("cvu")
    private String cvu;

    public String getCvu() {
        return cvu;
    }

    public void setCvu(String cvu) {
        this.cvu = cvu;
    }

    @Override
    public String toString() {
        return "DeleteBajaCVU [" +
                ((cvu != null) ? "cvu='" + cvu + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DeleteBajaCVUResponse that = (DeleteBajaCVUResponse) o;
        return Objects.equals(cvu, that.cvu);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(cvu);
    }
}
