/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.bindapi.core;

import ar.com.sdd.bindapi.core.BindApiConnectorContext;
import ar.com.sdd.bindapi.io.CommonError;
import ar.com.sdd.bindapi.io.DeleteBajaCVUResponse;
import ar.com.sdd.bindapi.io.DeleteEliminarPedidoDebinResponse;
import ar.com.sdd.bindapi.io.GetConsultaDatosVendedorResponse;
import ar.com.sdd.bindapi.io.GetInformaNovedadesDeEcheqs;
import ar.com.sdd.bindapi.io.PostABMPedidoDeRecurrenciaDeDebinRequest;
import ar.com.sdd.bindapi.io.PostAltaCVUClienteRequest;
import ar.com.sdd.bindapi.io.PostAltaCVUClienteResponse;
import ar.com.sdd.bindapi.io.PostAsignarModificarAliasCVURequest;
import ar.com.sdd.bindapi.io.PostAsignarModificarAliasCVUResponse;
import ar.com.sdd.bindapi.io.PostCrearPedidoDebinRequest;
import ar.com.sdd.bindapi.io.PostCrearPedidoDebinResponse;
import ar.com.sdd.bindapi.io.PostEmitirChequeRequest;
import ar.com.sdd.bindapi.io.PostEmitirChequeResponse;
import ar.com.sdd.bindapi.io.PostLoginRequest;
import ar.com.sdd.bindapi.io.PostLoginResponse;
import ar.com.sdd.bindapi.io.PostRealizarTransferenciaDesdeCVURequest;
import ar.com.sdd.bindapi.io.PutAltaBajaCuentaVendedorRequest;
import ar.com.sdd.bindapi.io.PutAltaBajaCuentaVendedorResponse;
import ar.com.sdd.bindapi.io.PutGestionarChequeRequest;
import ar.com.sdd.bindapi.io.PutGestionarChequeResponse;
import ar.com.sdd.bindapi.io.PutModificarCVUClienteRequest;
import ar.com.sdd.bindapi.io.PutModificarCVUClienteResponse;
import ar.com.sdd.bindapi.model.Account;
import ar.com.sdd.bindapi.model.Transaction;
import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.util.SimpleCache;
import ar.com.sdd.commons.util.SimpleCacheManager;
import javax.ws.rs.client.Invocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BindApiConnector
implements RestSecurityManager {
    private static final Logger log = LogManager.getLogger(BindApiConnector.class);
    private final RestConnector connector;
    private final String username;
    private final String password;
    private boolean doingLogin = false;

    public BindApiConnector(BindApiConnectorContext context) {
        this.username = context.getUsername();
        this.password = context.getPassword();
        log.trace("Creando BindApiConnector con {}", (Object)context);
        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getBaseUrl());
        this.connector = new RestConnector(environment, (RestSecurityManager)this);
    }

    public Account[] getAccounts(long bankId, String viewId) throws RestConnectorException {
        String path = "/banks/" + bankId + "/accounts/" + viewId;
        log.debug("[getAccounts] Listando cuentas con path [{}]", (Object)path);
        return (Account[])this.connector.genericGet(null, Account[].class, CommonError.class, path);
    }

    public PostCrearPedidoDebinResponse postCrearPedidoDebinResponse(long bankId, String accountId, String viewId, PostCrearPedidoDebinRequest postCrearPedidoDebinRequest) throws RestConnectorException {
        String path = "/banks/" + bankId + "/accounts/" + accountId + "/" + viewId + "/transaction-request-types/DEBIN/transaction-requests";
        log.debug("[postCrearPedidoDebinResponse] Creando pedido Debin con path [{}] y [{}]", (Object)path, (Object)postCrearPedidoDebinRequest);
        return (PostCrearPedidoDebinResponse)this.connector.genericPost((Object)postCrearPedidoDebinRequest, PostCrearPedidoDebinResponse.class, CommonError.class, path);
    }

    public GetConsultaDatosVendedorResponse getConsultaDatosVendedorResponse(long bankId, String accountId, String viewId) throws RestConnectorException {
        String path = "/banks/" + bankId + "/accounts/" + accountId + "/" + viewId + "/transaction-request-types/DEBIN/info";
        log.debug("[getConsultaDatosVendedorResponse] Consultando datos de vendedor Debin con path [{}]", (Object)path);
        return (GetConsultaDatosVendedorResponse)this.connector.genericGet(null, GetConsultaDatosVendedorResponse.class, CommonError.class, path);
    }

    public Transaction[] getObtenerDebinesParaCobrar(long bankId, String accountId, String viewId) throws RestConnectorException {
        String path = "/banks/" + bankId + "/accounts/" + accountId + "/" + viewId + "/transaction-request-types/DEBIN";
        log.debug("[getObtenerDebinesParaCobrar] Obteniendo Debines para cobrar con path [{}]", (Object)path);
        return (Transaction[])this.connector.genericGet(null, Transaction[].class, CommonError.class, path);
    }

    public Transaction getObtenerDebin(long bankId, String accountId, String viewId, String transactioId) throws RestConnectorException {
        String path = "/banks/" + bankId + "/accounts/" + accountId + "/" + viewId + "/transaction-request-types/DEBIN/" + transactioId;
        log.debug("[getObtenerDebin] Obteniendo Debin con path [{}]", (Object)path);
        return (Transaction)this.connector.genericGet(null, Transaction.class, CommonError.class, path);
    }

    public DeleteEliminarPedidoDebinResponse deleteEliminarPedidoDebinResponse(long bankId, String accountId, String viewId, String transactioId) throws RestConnectorException {
        String path = "/banks/" + bankId + "/accounts/" + accountId + "/" + viewId + "/transaction-request-types/DEBIN/" + transactioId;
        log.debug("[deleteEliminarPedidoDebinResponse] Eliminando pedido Debin con path [{}]", (Object)path);
        return (DeleteEliminarPedidoDebinResponse)this.connector.genericDelete(null, DeleteEliminarPedidoDebinResponse.class, CommonError.class, path);
    }

    public PutAltaBajaCuentaVendedorResponse putAltaBajaCuentaVendedorResponse(long bankId, String accountId, String viewId, PutAltaBajaCuentaVendedorRequest putAltaBajaCuentaVendedorRequest) throws RestConnectorException {
        String path = "/banks/" + bankId + "/accounts/" + accountId + "/" + viewId + "/transaction-request-types/DEBIN/";
        log.debug("[putAltaBajaCuentaVendedorResponse] Dando alta/baja cuenta vendedor Debin con path [{}] y [{}]", (Object)path, (Object)putAltaBajaCuentaVendedorRequest);
        return (PutAltaBajaCuentaVendedorResponse)this.connector.genericPut((Object)putAltaBajaCuentaVendedorRequest, PutAltaBajaCuentaVendedorResponse.class, CommonError.class, path);
    }

    public Transaction postABMPedidoDeRecurrenciaDeDebinResponse(long bankId, String viewId, PostABMPedidoDeRecurrenciaDeDebinRequest postABMPedidoDeRecurrenciaDeDebinRequest) throws RestConnectorException {
        String path = "/banks/" + bankId + "/" + viewId + "/transaction-request-types/DEBIN-SUBSCRIPTION/transaction-requests";
        log.debug("[postABMPedidoDeRecurrenciaDeDebinResponse] Creando pedido de recurrencia Debin con path [{}] y [{}]", (Object)path, (Object)postABMPedidoDeRecurrenciaDeDebinRequest);
        return (Transaction)this.connector.genericPost((Object)postABMPedidoDeRecurrenciaDeDebinRequest, Transaction.class, CommonError.class, path);
    }

    public PostAltaCVUClienteResponse postAltaCVUClienteResponse(long bankId, String accountId, String viewId, PostAltaCVUClienteRequest postAltaCVUClienteRequest) throws RestConnectorException {
        String path = "/banks/" + bankId + "/accounts/" + accountId + "/" + viewId + "/wallet/cvu";
        log.debug("[postAltaCVUClienteResponse] Creando CVU cliente con path [{}] y [{}]", (Object)path, (Object)postAltaCVUClienteRequest);
        return (PostAltaCVUClienteResponse)this.connector.genericPost((Object)postAltaCVUClienteRequest, PostAltaCVUClienteResponse.class, CommonError.class, path);
    }

    public PostAsignarModificarAliasCVUResponse postAsignarModificarAliasCVUResponse(long bankId, String accountId, String viewId, PostAsignarModificarAliasCVURequest postAsignarModificarAliasCVURequest) throws RestConnectorException {
        String path = "/banks/" + bankId + "/accounts/" + accountId + "/" + viewId + "/wallet/alias";
        log.debug("[postAsignarModificarAliasCVUResponse] Asignando/modificando alias CVU con path [{}] y [{}]", (Object)path, (Object)postAsignarModificarAliasCVURequest);
        return (PostAsignarModificarAliasCVUResponse)this.connector.genericPost((Object)postAsignarModificarAliasCVURequest, PostAsignarModificarAliasCVUResponse.class, CommonError.class, path);
    }

    public Transaction postRealizarTransferenciaDesdeCVU(long bankId, String accountId, String viewId, PostRealizarTransferenciaDesdeCVURequest postRealizarTransferenciaDesdeCVURequest) throws RestConnectorException {
        String path = "/banks/" + bankId + "/accounts/" + accountId + "/" + viewId + "/transaction-request-types/TRANSFER-CVU/transaction-requests";
        log.debug("[postRealizarTransferenciaDesdeCVUResponse] Realizando transferencia desde CVU con path [{}] y [{}]", (Object)path, (Object)postRealizarTransferenciaDesdeCVURequest);
        return (Transaction)this.connector.genericPost((Object)postRealizarTransferenciaDesdeCVURequest, Transaction.class, CommonError.class, path);
    }

    public Transaction[] getObtenerListadoDeTransferencias(long bankId, String accountId, String viewId) throws RestConnectorException {
        String path = "/banks/" + bankId + "/accounts/" + accountId + "/" + viewId + "/transaction-request-types/TRANSFER-CVU";
        log.debug("[getObtenerListadoDeTransferencias] Obteniendo listado de transferencias con path [{}]", (Object)path);
        return (Transaction[])this.connector.genericGet(null, Transaction[].class, CommonError.class, path);
    }

    public Transaction getObtenerTransferencia(long bankId, String accountId, String viewId, String transactionId) throws RestConnectorException {
        String path = "/banks/" + bankId + "/accounts/" + accountId + "/" + viewId + "/transaction-request-types/TRANSFER-CVU/" + transactionId;
        log.debug("[getObtenerTransferencialong] Obteniendo transferencia con path [{}]", (Object)path);
        return (Transaction)this.connector.genericGet(null, Transaction.class, CommonError.class, path);
    }

    public DeleteBajaCVUResponse deleteBajaCVUResponse(long bankId, String accountId, String viewId, String cvu, String cuit) throws RestConnectorException {
        String path = "/banks/" + bankId + "/accounts/" + accountId + "/" + viewId + "/wallet/cvu/" + cvu + "/" + cuit;
        log.debug("[DeleteBajaCVU] Dando de baja CVU con path [{}]", (Object)path);
        return (DeleteBajaCVUResponse)this.connector.genericDelete(null, DeleteBajaCVUResponse.class, CommonError.class, path);
    }

    public PutModificarCVUClienteResponse putModificarCVUCliente(long bankId, String accountId, String viewId, String cvu, PutModificarCVUClienteRequest putModificarCVUClienteRequest) throws RestConnectorException {
        String path = "/banks/" + bankId + "/accounts/" + accountId + "/" + viewId + "/wallet/cvu/" + cvu;
        log.debug("[putModificarCVUCliente] Modificando CVU cliente con path [{}] y [{}]", (Object)path, (Object)putModificarCVUClienteRequest);
        return (PutModificarCVUClienteResponse)this.connector.genericPut((Object)putModificarCVUClienteRequest, PutModificarCVUClienteResponse.class, CommonError.class, path);
    }

    public PostEmitirChequeResponse postEmitirChequeResponse(long bankId, String accountId, String viewId, PostEmitirChequeRequest postEmitirChequeRequest) throws RestConnectorException {
        String path = "/banks/" + bankId + "/accounts/" + accountId + "/" + viewId + "/transaction-request-types/CHECK";
        log.debug("[postEmitirCheque] Emitiendo cheque con path [{}] y [{}]", (Object)path, (Object)postEmitirChequeRequest);
        return (PostEmitirChequeResponse)this.connector.genericPost((Object)postEmitirChequeRequest, PostEmitirChequeResponse.class, CommonError.class, path);
    }

    public PutGestionarChequeResponse putGestionarChequeResponse(long bankId, String accountId, String viewId, PutGestionarChequeRequest putGestionarChequeRequest) throws RestConnectorException {
        String path = "/banks/" + bankId + "/accounts/" + accountId + "/" + viewId + "/transaction-request-types/CHECK";
        log.debug("[putGestionarChequeResponse] Gestionando cheque con path [{}] y [{}]", (Object)path, (Object)putGestionarChequeRequest);
        return (PutGestionarChequeResponse)this.connector.genericPut((Object)putGestionarChequeRequest, PutGestionarChequeResponse.class, CommonError.class, path);
    }

    public GetInformaNovedadesDeEcheqs getInformaNovedadesDeEcheqsResponse(long bankId, String viewId) throws RestConnectorException {
        String path = "/banks/" + bankId + "/echeq/" + viewId + "/notification";
        log.debug("[getInformaNovedadesDeEcheqsResponse] Obteniendo novedades de Echeqs con path [{}]", (Object)path);
        return (GetInformaNovedadesDeEcheqs)this.connector.genericGet(null, GetInformaNovedadesDeEcheqs.class, CommonError.class, path);
    }

    public Transaction[] getObtenerCheques(long bankId, String accountId, String viewId) throws RestConnectorException {
        String path = "/banks/" + bankId + "/accounts/" + accountId + "/" + viewId + "/transaction-request-types/CHECK";
        log.debug("[getObtenerCheques] Obteniendo cheques con path [{}]", (Object)path);
        return (Transaction[])this.connector.genericGet(null, Transaction[].class, CommonError.class, path);
    }

    public Transaction getObtenerCheque(long bankId, String accountId, String viewId, String id) throws RestConnectorException {
        String path = "/banks/" + bankId + "/accounts/" + accountId + "/" + viewId + "/transaction-request-types/CHECK/" + id;
        log.debug("[getObtenerCheque] Obteniendo cheque con path [{}]", (Object)path);
        return (Transaction)this.connector.genericGet(null, Transaction.class, CommonError.class, path);
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        if (builder != null && !this.doingLogin) {
            builder.header("Authorization", (Object)("JWT " + this.getJWTToken(false)));
        }
        return builder;
    }

    public boolean retryOnUnauthorized() {
        if (!this.doingLogin) {
            try {
                this.getJWTToken(true);
                return true;
            }
            catch (RestConnectorException e) {
                log.error((Object)e);
                return false;
            }
        }
        return false;
    }

    public boolean getDisableHTTPSErrors() {
        return false;
    }

    public String getJWTToken(boolean force) throws RestConnectorException {
        SimpleCache cache = SimpleCacheManager.getInstance().getCache(BindApiConnector.class.getName());
        String cacheKey = SimpleCacheManager.buildKey((Object[])new Object[]{"jwtToken"});
        String jwtToken = (String)cache.get(cacheKey);
        if (force || jwtToken == null) {
            log.debug("[getJWTToken] Obteniendo token con username [{}]", (Object)this.username);
            PostLoginRequest request = new PostLoginRequest(this.username, this.password);
            log.debug("[getJWTToken] Por hacer login con {}", (Object)request);
            this.doingLogin = true;
            PostLoginResponse postLoginResponse = (PostLoginResponse)this.connector.genericPost((Object)request, PostLoginResponse.class, CommonError.class, "/login/jwt");
            this.doingLogin = false;
            jwtToken = postLoginResponse.getToken();
            log.debug("[getJWTToken] Token recuperado [{}], expira en [{}] segs", (Object)jwtToken, (Object)(postLoginResponse.getExpiresIn() - 10));
            cache.put(cacheKey, (Object)jwtToken, Integer.valueOf(postLoginResponse.getExpiresIn() - 10));
        }
        return jwtToken;
    }
}

