package ar.com.sdd.bindapi.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PostAltaCVUClienteResponse implements Serializable {

    @JsonProperty("cvu")
    private String cvu;

    @JsonProperty("label")
    private String label;

    @JsonProperty("reactivated")
    private Boolean reactivated;

    public String getCvu() {
        return cvu;
    }

    public void setCvu(String cvu) {
        this.cvu = cvu;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Boolean isReactivated() {
        return reactivated;
    }

    public void setReactivated(Boolean reactivated) {
        this.reactivated = reactivated;
    }

    @Override
    public String toString() {
        return "PostAltaCVUClienteRequest [" +
                ((cvu != null) ? "cvu='" + cvu + "', " : "") +
                ((label != null) ? "label='" + label + "', " : "") +
                ((reactivated != null) ? "reactivated=" + reactivated + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PostAltaCVUClienteResponse that = (PostAltaCVUClienteResponse) o;
        return Objects.equals(cvu, that.cvu) && Objects.equals(label, that.label) && Objects.equals(reactivated, that.reactivated);
    }

    @Override
    public int hashCode() {
        return Objects.hash(cvu, label, reactivated);
    }
}
