package ar.com.sdd.bindapi.io;

import ar.com.sdd.bindapi.model.To;
import ar.com.sdd.bindapi.model.Value;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PostCrearPedidoDebinRequest implements Serializable {

    @JsonProperty("origin_id")
    private String originId;

    @JsonProperty("to")
    private To to;

    @JsonProperty("value")
    private Value value;

    @JsonProperty("concept")
    private String concept;

    @JsonProperty("expiration")
    private Integer expiration;

    @JsonProperty("provision")
    private String provision;

    public String getOriginId() {
        return originId;
    }

    public void setOriginId(String originId) {
        this.originId = originId;
    }

    public To getTo() {
        return to;
    }

    public void setTo(To to) {
        this.to = to;
    }

    public Value getValue() {
        return value;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    public String getConcept() {
        return concept;
    }

    public void setConcept(String concept) {
        this.concept = concept;
    }

    public Integer getExpiration() {
        return expiration;
    }

    public void setExpiration(Integer expiration) {
        this.expiration = expiration;
    }

    public String getProvision() {
        return provision;
    }

    public void setProvision(String provision) {
        this.provision = provision;
    }

    @Override
    public String toString() {
        return "PostCrearPedidoDebinRequest [" +
                ((originId != null) ? "originId='" + originId + "', " : "") +
                ((to != null) ? "to=" + to + ", " : "") +
                ((value != null) ? "value=" + value + ", " : "") +
                ((concept != null) ? "concept='" + concept + "', " : "") +
                ((expiration != null) ? "expiration=" + expiration + ", " : "") +
                ((provision != null) ? "provision='" + provision + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PostCrearPedidoDebinRequest that = (PostCrearPedidoDebinRequest) o;
        return Objects.equals(originId, that.originId) &&
                Objects.equals(to, that.to) &&
                Objects.equals(value, that.value) &&
                Objects.equals(concept, that.concept) &&
                Objects.equals(expiration, that.expiration) &&
                Objects.equals(provision, that.provision);
    }

    @Override
    public int hashCode() {
        return Objects.hash(originId, to, value, concept, expiration, provision);
    }
}
