package ar.com.sdd.bindapi.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PutAltaBajaCuentaVendedorResponse implements Serializable {

    @JsonProperty("adhered")
    private Boolean adhered;

    @JsonProperty("account_id")
    private String accountId;

    public Boolean getAdhered() {
        return adhered;
    }

    public void setAdhered(Boolean adhered) {
        this.adhered = adhered;
    }

    public String getAccountId() {
        return accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    @Override
    public String toString() {
        return "PutAltaBajaCuentaVendedorResponse [" +
                ((adhered != null) ? "adhered=" + adhered + ", " : "") +
                ((accountId != null) ? "accountId='" + accountId + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PutAltaBajaCuentaVendedorResponse that = (PutAltaBajaCuentaVendedorResponse) o;
        return Objects.equals(adhered, that.adhered) && Objects.equals(accountId, that.accountId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(adhered, accountId);
    }
}
