package ar.com.sdd.bindapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class AccountRouting implements Serializable {

    @JsonProperty("scheme")
    private String scheme;

    @JsonProperty("address")
    private String address;

    public String getScheme() {
        return scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @Override
    public String toString() {
        return "AccountRouting [" +
                ((scheme != null) ? "scheme='" + scheme + "', " : "") +
                ((address != null) ? "address='" + address + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AccountRouting that = (AccountRouting) o;
        return Objects.equals(scheme, that.scheme) && Objects.equals(address, that.address);
    }

    @Override
    public int hashCode() {
        return Objects.hash(scheme, address);
    }
}