package ar.com.sdd.bindapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Endorsments implements Serializable {

    @JsonProperty("date_time")
    private String dateTime;

    @JsonProperty("document_type")
    private String documentType;

    @JsonProperty("document")
    private String document;

    @JsonProperty("name")
    private String name;

    @JsonProperty("emissor_document_type")
    private String emissorDocumentType;

    @JsonProperty("emissor_document")
    private String emissorDocument;

    @JsonProperty("emissor_name")
    private String emissorName;

    @JsonProperty("endorsement_type")
    private String endorsementType;

    @JsonProperty("rejection_motive")
    private String rejectionMotive;

    @JsonProperty("endorsement_state")
    private String endorsementState;

    @JsonProperty("payment_references_count")
    private Integer paymentReferencesCount;

    @JsonProperty("payment_reference")
    private List<PaymentReference> paymentReference;

    public String getDateTime() {
        return dateTime;
    }

    public void setDateTime(String dateTime) {
        this.dateTime = dateTime;
    }

    public String getDocumentType() {
        return documentType;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    public String getDocument() {
        return document;
    }

    public void setDocument(String document) {
        this.document = document;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEmissorDocumentType() {
        return emissorDocumentType;
    }

    public void setEmissorDocumentType(String emissorDocumentType) {
        this.emissorDocumentType = emissorDocumentType;
    }

    public String getEmissorDocument() {
        return emissorDocument;
    }

    public void setEmissorDocument(String emissorDocument) {
        this.emissorDocument = emissorDocument;
    }

    public String getEmissorName() {
        return emissorName;
    }

    public void setEmissorName(String emissorName) {
        this.emissorName = emissorName;
    }

    public String getEndorsementType() {
        return endorsementType;
    }

    public void setEndorsementType(String endorsementType) {
        this.endorsementType = endorsementType;
    }

    public String getRejectionMotive() {
        return rejectionMotive;
    }

    public void setRejectionMotive(String rejectionMotive) {
        this.rejectionMotive = rejectionMotive;
    }

    public String getEndorsementState() {
        return endorsementState;
    }

    public void setEndorsementState(String endorsementState) {
        this.endorsementState = endorsementState;
    }

    public Integer getPaymentReferencesCount() {
        return paymentReferencesCount;
    }

    public void setPaymentReferencesCount(Integer paymentReferencesCount) {
        this.paymentReferencesCount = paymentReferencesCount;
    }

    public List<PaymentReference> getPaymentReference() {
        return paymentReference;
    }

    public void setPaymentReference(List<PaymentReference> paymentReference) {
        this.paymentReference = paymentReference;
    }

    @Override
    public String toString() {
        return "Endorsments [" +
                ((dateTime != null) ? "dateTime='" + dateTime + "', " : "") +
                ((documentType != null) ? "documentType='" + documentType + "', " : "") +
                ((document != null) ? "document='" + document + "', " : "") +
                ((name != null) ? "name='" + name + "', " : "") +
                ((emissorDocumentType != null) ? "emissorDocumentType='" + emissorDocumentType + "', " : "") +
                ((emissorDocument != null) ? "emissorDocument='" + emissorDocument + "', " : "") +
                ((emissorName != null) ? "emissorName='" + emissorName + "', " : "") +
                ((endorsementType != null) ? "endorsementType='" + endorsementType + "', " : "") +
                ((rejectionMotive != null) ? "rejectionMotive='" + rejectionMotive + "', " : "") +
                ((endorsementState != null) ? "endorsementState='" + endorsementState + "', " : "") +
                ((paymentReferencesCount != null) ? "paymentReferencesCount=" + paymentReferencesCount + ", " : "") +
                ((paymentReference != null) ? "paymentReference=" + Arrays.toString(paymentReference.toArray()) + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Endorsments that = (Endorsments) o;
        return Objects.equals(dateTime, that.dateTime) &&
                Objects.equals(documentType, that.documentType) &&
                Objects.equals(document, that.document) &&
                Objects.equals(name, that.name) &&
                Objects.equals(emissorDocumentType, that.emissorDocumentType) &&
                Objects.equals(emissorDocument, that.emissorDocument) &&
                Objects.equals(emissorName, that.emissorName) &&
                Objects.equals(endorsementType, that.endorsementType) &&
                Objects.equals(rejectionMotive, that.rejectionMotive) &&
                Objects.equals(endorsementState, that.endorsementState) &&
                Objects.equals(paymentReferencesCount, that.paymentReferencesCount) &&
                Objects.deepEquals(paymentReference, that.paymentReference);
    }

    @Override
    public int hashCode() {
        return Objects.hash(dateTime, documentType, document, name, emissorDocumentType, emissorDocument, emissorName, endorsementType, rejectionMotive,
                endorsementState, paymentReferencesCount, paymentReference);
    }
}
