package ar.com.sdd.bindapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class From implements Serializable {

    @JsonProperty("bank_id")
    public String bankId;

    @JsonProperty("account_id")
    public String accountId;

    public String getBankId() {
        return bankId;
    }

    public void setBankId(String bankId) {
        this.bankId = bankId;
    }

    public String getAccountId() {
        return accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    @Override
    public String toString() {
        return "From [" +
                ((bankId != null) ? "bankId='" + bankId + "', " : "") +
                ((accountId != null) ? "accountId='" + accountId + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        From from = (From) o;
        return Objects.equals(bankId, from.bankId) && Objects.equals(accountId, from.accountId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(bankId, accountId);
    }
}