package ar.com.sdd.bindapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class To implements Serializable {

    @JsonProperty("cuit")
    public String cuit;

    @JsonProperty("label")
    public String label;

    @JsonProperty("cbu")
    public String cbu;

    public String getCuit() {
        return cuit;
    }

    public void setCuit(String cuit) {
        this.cuit = cuit;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getCbu() {
        return cbu;
    }

    public void setCbu(String cbu) {
        this.cbu = cbu;
    }

    @Override
    public String toString() {
        return "To [" +
                ((cuit != null) ? "cuit='" + cuit + "', " : "") +
                ((label != null) ? "label='" + label + "', " : "") +
                ((cbu != null) ? "cbu='" + cbu + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        To that = (To) o;
        return Objects.equals(cuit, that.cuit) && Objects.equals(label, that.label) && Objects.equals(cbu, that.cbu);
    }

    @Override
    public int hashCode() {
        return Objects.hash(cuit, label, cbu);
    }
}