package ar.com.sdd.bindapi.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class CommonError implements Serializable {

    @JsonProperty("code")
    private String code;

    @JsonProperty("message")
    private String message;

    @JsonProperty("moreInfo")
    private String moreInfo;

    @JsonProperty("process")
    private String process;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMoreInfo() {
        return moreInfo;
    }

    public void setMoreInfo(String moreInfo) {
        this.moreInfo = moreInfo;
    }

    public String getProcess() {
        return process;
    }

    public void setProcess(String process) {
        this.process = process;
    }

    @Override
    public String toString() {
        return "CommonError [" +
                ((code != null) ? "code='" + code + "', " : "") +
                ((message != null) ? "message='" + message + "', " : "") +
                ((moreInfo != null) ? "moreInfo='" + moreInfo + "', " : "") +
                ((process != null) ? "process='" + process + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CommonError that = (CommonError) o;
        return Objects.equals(code, that.code) && Objects.equals(message, that.message) && Objects.equals(moreInfo, that.moreInfo) && Objects.equals(process, that.process);
    }

    @Override
    public int hashCode() {
        return Objects.hash(code, message, moreInfo, process);
    }
}
