package ar.com.sdd.bindapi.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PostAltaCVUClienteRequest implements Serializable {

    @JsonProperty("client_id")
    private Long clientId;

    @JsonProperty("cuit")
    private String cuit;

    @JsonProperty("name")
    private String name;

    @JsonProperty("currency")
    private String currency;

    public Long getClientId() {
        return clientId;
    }

    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    public String getCuit() {
        return cuit;
    }

    public void setCuit(String cuit) {
        this.cuit = cuit;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Override
    public String toString() {
        return "PostAltaCVUClienteResponse [" +
                ((clientId != null) ? "clientId=" + clientId + ", " : "") +
                ((cuit != null) ? "cuit='" + cuit + "', " : "") +
                ((name != null) ? "name='" + name + "', " : "") +
                ((currency != null) ? "currency='" + currency + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PostAltaCVUClienteRequest that = (PostAltaCVUClienteRequest) o;
        return Objects.equals(clientId, that.clientId) && Objects.equals(cuit, that.cuit) && Objects.equals(name, that.name) && Objects.equals(currency, that.currency);
    }

    @Override
    public int hashCode() {
        return Objects.hash(clientId, cuit, name, currency);
    }
}
