package ar.com.sdd.bindapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Account implements Serializable {

    @JsonProperty("id")
    private String id;

    @JsonProperty("label")
    private String label;

    @JsonProperty("number")
    private String number;

    @JsonProperty("type")
    private String type;

    @JsonProperty("status")
    private String status;

    @JsonProperty("owners")
    private List<Owner> owners;

    @JsonProperty("balance")
    private Balance balance;

    @JsonProperty("bank_id")
    private String bankId;

    @JsonProperty("account_routing")
    private AccountRouting accountRouting;

    public String getId() { return id; }
    public void setId(String id) { this.id = id; }

    public String getLabel() { return label; }
    public void setLabel(String label) { this.label = label; }

    public String getNumber() { return number; }
    public void setNumber(String number) { this.number = number; }

    public String getType() { return type; }
    public void setType(String type) { this.type = type; }

    public String getStatus() { return status; }
    public void setStatus(String status) { this.status = status; }

    public List<Owner> getOwners() { return owners; }
    public void setOwners(List<Owner> owners) { this.owners = owners; }

    public Balance getBalance() { return balance; }
    public void setBalance(Balance balance) { this.balance = balance; }

    public String getBankId() { return bankId; }
    public void setBankId(String bankId) { this.bankId = bankId; }

    public AccountRouting getAccountRouting() { return accountRouting; }
    public void setAccountRouting(AccountRouting accountRouting) { this.accountRouting = accountRouting; }

    @Override
    public String toString() {
        return "Account [" +
                ((id != null) ? "id='" + id + "', " : "") +
                ((label != null) ? "label='" + label + "', " : "") +
                ((number != null) ? "number='" + number + "', " : "") +
                ((type != null) ? "type='" + type + "', " : "") +
                ((status != null) ? "status='" + status + "', " : "") +
                ((owners != null) ? "owners=" + Arrays.toString(owners.toArray()) + ", " : "") +
                ((balance != null) ? "balance=" + balance + ", " : "") +
                ((bankId != null) ? "bankId='" + bankId + "', " : "") +
                ((accountRouting != null) ? "accountRouting=" + accountRouting + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Account account = (Account) o;
        return Objects.equals(id, account.id) && Objects.equals(label, account.label) && Objects.equals(number, account.number) && Objects.equals(type, account.type) && Objects.equals(status, account.status) && Objects.equals(owners, account.owners) && Objects.equals(balance, account.balance) && Objects.equals(bankId, account.bankId) && Objects.equals(accountRouting, account.accountRouting);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, label, number, type, status, owners, balance, bankId, accountRouting);
    }
}