package ar.com.sdd.bindapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Counterparty implements Serializable {

    @JsonProperty("id")
    private String id;

    @JsonProperty("name")
    private String name;

    @JsonProperty("id_type")
    private String idType;

    @JsonProperty("bank_routing")
    private BankRouting bankRouting;

    @JsonProperty("account_routing")
    private AccountRouting accountRouting;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIdType() {
        return idType;
    }

    public void setIdType(String idType) {
        this.idType = idType;
    }

    public BankRouting getBankRouting() {
        return bankRouting;
    }

    public void setBankRouting(BankRouting bankRouting) {
        this.bankRouting = bankRouting;
    }

    public AccountRouting getAccountRouting() {
        return accountRouting;
    }

    public void setAccountRouting(AccountRouting accountRouting) {
        this.accountRouting = accountRouting;
    }

    @Override
    public String toString() {
        return "Counterparty [" +
                ((id != null) ? "id='" + id + "', " : "") +
                ((name != null) ? "name='" + name + "', " : "") +
                ((idType != null) ? "idType='" + idType + "', " : "") +
                ((bankRouting != null) ? "bankRouting=" + bankRouting + ", " : "") +
                ((accountRouting != null) ? "accountRouting=" + accountRouting + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Counterparty that = (Counterparty) o;
        return Objects.equals(id, that.id) && Objects.equals(name, that.name) && Objects.equals(idType, that.idType) && Objects.equals(bankRouting, that.bankRouting) && Objects.equals(accountRouting, that.accountRouting);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, name, idType, bankRouting, accountRouting);
    }
}
