package ar.com.sdd.bindapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class OriginDebit implements Serializable {

    @JsonProperty("cvu")
    private String cvu;

    @JsonProperty("cuit")
    private String cuit;

    public String getCvu() {
        return cvu;
    }

    public void setCvu(String cvu) {
        this.cvu = cvu;
    }

    public String getCuit() {
        return cuit;
    }

    public void setCuit(String cuit) {
        this.cuit = cuit;
    }

    @Override
    public String toString() {
        return "OriginDebit [" +
                ((cvu != null) ? "cvu='" + cvu + "', " : "") +
                ((cuit != null) ? "cuit='" + cuit + "'" : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OriginDebit that = (OriginDebit) o;
        return Objects.equals(cvu, that.cvu) && Objects.equals(cuit, that.cuit);
    }

    @Override
    public int hashCode() {
        return Objects.hash(cvu, cuit);
    }
}
