package ar.com.sdd.bindapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Owner implements Serializable {

    @JsonProperty("id")
    private String id;

    @JsonProperty("display_name")
    private String displayName;

    @JsonProperty("id_type")
    private String idType;

    @JsonProperty("is_physical_person")
    private boolean isPhysicalPerson;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDisplayName() {
        return displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getIdType() {
        return idType;
    }

    public void setIdType(String idType) {
        this.idType = idType;
    }

    public boolean isPhysicalPerson() {
        return isPhysicalPerson;
    }

    public void setPhysicalPerson(boolean physicalPerson) {
        isPhysicalPerson = physicalPerson;
    }

    @Override
    public String toString() {
        return "Owner [" +
                ((id != null) ? "id='" + id + "', " : "") +
                ((displayName != null) ? "displayName='" + displayName + "', " : "") +
                ((idType != null) ? "idType='" + idType + "', " : "") +
                "isPhysicalPerson=" + isPhysicalPerson + ", " +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Owner owner = (Owner) o;
        return isPhysicalPerson == owner.isPhysicalPerson && Objects.equals(id, owner.id) && Objects.equals(displayName, owner.displayName) && Objects.equals(idType, owner.idType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, displayName, idType, isPhysicalPerson);
    }
}