package ar.com.sdd.bindapi.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class GetInformaNovedadesDeEcheqs implements Serializable {

    @JsonProperty("hasAdmit")
    private boolean hasAdmit;

    @JsonProperty("hasDisowned")
    private boolean hasDisowned;

    @JsonProperty("hasRejected")
    private boolean hasRejected;

    @JsonProperty("hasAskedReturn")
    private boolean hasAskedReturn;

    @JsonProperty("hasPayed")
    private boolean hasPayed;

    @JsonProperty("hasNotPayOrder")
    private boolean hasNotPayOrder;

    @JsonProperty("hasCollected")
    private boolean hasCollected;

    public boolean isHasAdmit() {
        return hasAdmit;
    }

    public void setHasAdmit(boolean hasAdmit) {
        this.hasAdmit = hasAdmit;
    }

    public boolean isHasDisowned() {
        return hasDisowned;
    }

    public void setHasDisowned(boolean hasDisowned) {
        this.hasDisowned = hasDisowned;
    }

    public boolean isHasRejected() {
        return hasRejected;
    }

    public void setHasRejected(boolean hasRejected) {
        this.hasRejected = hasRejected;
    }

    public boolean isHasAskedReturn() {
        return hasAskedReturn;
    }

    public void setHasAskedReturn(boolean hasAskedReturn) {
        this.hasAskedReturn = hasAskedReturn;
    }

    public boolean isHasPayed() {
        return hasPayed;
    }

    public void setHasPayed(boolean hasPayed) {
        this.hasPayed = hasPayed;
    }

    public boolean isHasNotPayOrder() {
        return hasNotPayOrder;
    }

    public void setHasNotPayOrder(boolean hasNotPayOrder) {
        this.hasNotPayOrder = hasNotPayOrder;
    }

    public boolean isHasCollected() {
        return hasCollected;
    }

    public void setHasCollected(boolean hasCollected) {
        this.hasCollected = hasCollected;
    }

    @Override
    public String toString() {
        return "GetInormaNovedadesDeEcheqsResponse [" +
                ((hasAdmit) ? "hasAdmit='" + hasAdmit + "', " : "") +
                ((hasDisowned) ? "hasDisowned='" + hasDisowned + "', " : "") +
                ((hasRejected) ? "hasRejected='" + hasRejected + "', " : "") +
                ((hasAskedReturn) ? "hasAskedReturn='" + hasAskedReturn + "', " : "") +
                ((hasPayed) ? "hasPayed='" + hasPayed + "', " : "") +
                ((hasNotPayOrder) ? "hasNotPayOrder='" + hasNotPayOrder + "', " : "") +
                ((hasCollected) ? "hasCollected='" + hasCollected + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GetInformaNovedadesDeEcheqs that = (GetInformaNovedadesDeEcheqs) o;
        return Objects.equals(hasAdmit, that.hasAdmit) &&
                Objects.equals(hasDisowned, that.hasDisowned) &&
                Objects.equals(hasRejected, that.hasRejected) &&
                Objects.equals(hasAskedReturn, that.hasAskedReturn) &&
                Objects.equals(hasPayed, that.hasPayed) &&
                Objects.equals(hasNotPayOrder, that.hasNotPayOrder) &&
                Objects.equals(hasCollected, that.hasCollected);
    }

    @Override
    public int hashCode() {
        return Objects.hash(hasAdmit, hasDisowned, hasRejected, hasAskedReturn, hasPayed, hasNotPayOrder, hasCollected);
    }
}
