package ar.com.sdd.bindapi.io;

import ar.com.sdd.bindapi.model.To;
import ar.com.sdd.bindapi.model.Value;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PostABMPedidoDeRecurrenciaDeDebinRequest implements Serializable {

    @JsonProperty("id")
    private String id;

    @JsonProperty("to")
    private To to;

    @JsonProperty("value")
    private Value value;

    @JsonProperty("description")
    private String description;

    @JsonProperty("concept")
    private String concept;

    @JsonProperty("provision")
    private String provision;

    @JsonProperty("provision_reference")
    private String provisionReference;

    @JsonProperty("active")
    private Boolean active;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public To getTo() {
        return to;
    }

    public void setTo(To to) {
        this.to = to;
    }

    public Value getValue() {
        return value;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getConcept() {
        return concept;
    }

    public void setConcept(String concept) {
        this.concept = concept;
    }

    public String getProvision() {
        return provision;
    }

    public void setProvision(String provision) {
        this.provision = provision;
    }

    public String getProvisionReference() {
        return provisionReference;
    }

    public void setProvisionReference(String provisionReference) {
        this.provisionReference = provisionReference;
    }

    public Boolean getActive() {
        return active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    @Override
    public String toString() {
        return "PostABMPedidoDeRecurrenciaDeDebinRequest [" +
                ((id != null) ? "id='" + id + "', " : "") +
                ((to != null) ? "to=" + to + ", " : "") +
                ((value != null) ? "value=" + value + ", " : "") +
                ((description != null) ? "description='" + description + "', " : "") +
                ((concept != null) ? "concept='" + concept + "', " : "") +
                ((provision != null) ? "provision='" + provision + "', " : "") +
                ((provisionReference != null) ? "provisionReference='" + provisionReference + "', " : "") +
                ((active != null) ? "active=" + active + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PostABMPedidoDeRecurrenciaDeDebinRequest that = (PostABMPedidoDeRecurrenciaDeDebinRequest) o;
        return Objects.equals(id, that.id) && Objects.equals(to, that.to) && Objects.equals(value, that.value) && Objects.equals(description, that.description) && Objects.equals(concept, that.concept) && Objects.equals(provision, that.provision) && Objects.equals(provisionReference, that.provisionReference) && Objects.equals(active, that.active);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, to, value, description, concept, provision, provisionReference, active);
    }
}
