package ar.com.sdd.bindapi.io;

import ar.com.sdd.bindapi.model.Charge;
import ar.com.sdd.bindapi.model.Details;
import ar.com.sdd.bindapi.model.From;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PostEmitirChequeResponse implements Serializable {

    @JsonProperty("id")
    private String id;

    @JsonProperty("type")
    private String type;

    @JsonProperty("from")
    private From from;

    @JsonProperty("details")
    private Details details;

    @JsonProperty("transaction_ids")
    private List<String> transactionIds;

    @JsonProperty("status")
    private String status;

    @JsonProperty("start_date")
    private String startDate;

    @JsonProperty("end_date")
    private String endDate;

    @JsonProperty("charge")
    private Charge charge;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public From getFrom() {
        return from;
    }

    public void setFrom(From from) {
        this.from = from;
    }

    public Details getDetails() {
        return details;
    }

    public void setDetails(Details details) {
        this.details = details;
    }

    public List<String> getTransactionIds() {
        return transactionIds;
    }

    public void setTransactionIds(List<String> transactionIds) {
        this.transactionIds = transactionIds;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStartDate() {
        return startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public Charge getCharge() {
        return charge;
    }

    public void setCharge(Charge charge) {
        this.charge = charge;
    }

    @Override
    public String toString() {
        return "PostEmitirChequeResponse [" +
                ((id != null) ? "id='" + id + "', " : "") +
                ((type != null) ? "type='" + type + "', " : "") +
                ((from != null) ? "from=" + from + ", " : "") +
                ((details != null) ? "details=" + details + ", " : "") +
                ((transactionIds != null) ? "transactionIds=" + Arrays.toString(transactionIds.toArray()) + ", " : "") +
                ((status != null) ? "status='" + status + "', " : "") +
                ((startDate != null) ? "startDate='" + startDate + "', " : "") +
                ((endDate != null) ? "endDate='" + endDate + "', " : "") +
                ((charge != null) ? "charge=" + charge + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PostEmitirChequeResponse that = (PostEmitirChequeResponse) o;
        return Objects.equals(id, that.id) && Objects.equals(type, that.type) && Objects.equals(from, that.from) && Objects.equals(details, that.details) && Objects.equals(transactionIds, that.transactionIds) && Objects.equals(status, that.status) && Objects.equals(startDate, that.startDate) && Objects.equals(endDate, that.endDate) && Objects.equals(charge, that.charge);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, type, from, details, transactionIds, status, startDate, endDate, charge);
    }
}