package ar.com.sdd.bindapi.io;

import ar.com.sdd.bindapi.model.Check;

import ar.com.sdd.bindapi.model.Reference;
import ar.com.sdd.bindapi.model.To;
import ar.com.sdd.bindapi.model.Value;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PutGestionarChequeRequest implements Serializable {

    @JsonProperty("origin_id")
    private String originId;

    @JsonProperty("action")
    private String action;

    @JsonProperty("to")
    private To to;

    @JsonProperty("value")
    private Value value;

    @JsonProperty("check")
    private Check check;

    @JsonProperty("motive")
    private String motive;

    @JsonProperty("references")
    private List<Reference> references;

    public String getOriginId() {
        return originId;
    }

    public void setOriginId(String originId) {
        this.originId = originId;
    }

    public String getAction() {
        return action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public To getTo() {
        return to;
    }

    public void setTo(To to) {
        this.to = to;
    }

    public Value getValue() {
        return value;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    public Check getCheck() {
        return check;
    }

    public void setCheck(Check check) {
        this.check = check;
    }

    public String getMotive() {
        return motive;
    }

    public void setMotive(String motive) {
        this.motive = motive;
    }

    public List<Reference> getReferences() {
        return references;
    }

    public void setReferences(List<Reference> references) {
        this.references = references;
    }

    @Override
    public String toString() {
        return "PutGestionarChequeRequest [" +
                ((originId != null) ? "originId='" + originId + "', " : "") +
                ((action != null) ? "action='" + action + "', " : "") +
                ((to != null) ? "to=" + to + ", " : "") +
                ((value != null) ? "value=" + value + ", " : "") +
                ((check != null) ? "check=" + check + ", " : "") +
                ((motive != null) ? "motive='" + motive + "', " : "") +
                ((references != null) ? "references=" + Arrays.toString(references.toArray()) + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PutGestionarChequeRequest that = (PutGestionarChequeRequest) o;
        return Objects.equals(originId, that.originId) &&
                Objects.equals(action, that.action) &&
                Objects.equals(to, that.to) &&
                Objects.equals(value, that.value) &&
                Objects.equals(check, that.check) &&
                Objects.equals(motive, that.motive) &&
                Objects.equals(references, that.references);
    }

    @Override
    public int hashCode() {
        return Objects.hash(originId, action, to, value, check, motive, references);
    }
}
