package ar.com.sdd.bindapi.io;

import ar.com.sdd.bindapi.model.AccountRouting;
import ar.com.sdd.bindapi.model.BankRouting;
import ar.com.sdd.bindapi.model.Owner;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class GetConsultaCuentaPorAliasCbuCvuResponse implements Serializable {

    @JsonProperty("owner")
    private List<Owner> owner;

    @JsonProperty("type")
    private String type;

    @JsonProperty("is_active")
    private Boolean isActive;

    @JsonProperty("currency")
    private String currency;

    @JsonProperty("label")
    private String label;

    @JsonProperty("account_routing")
    private AccountRouting accountRouting;

    @JsonProperty("bank_routing")
    private BankRouting bankRouting;

    public List<Owner> getOwner() {
        return owner;
    }

    public void setOwner(List<Owner> owner) {
        this.owner = owner;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Boolean getActive() {
        return isActive;
    }

    public void setActive(Boolean active) {
        isActive = active;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public AccountRouting getAccountRouting() {
        return accountRouting;
    }

    public void setAccountRouting(AccountRouting accountRouting) {
        this.accountRouting = accountRouting;
    }

    public BankRouting getBankRouting() {
        return bankRouting;
    }

    public void setBankRouting(BankRouting bankRouting) {
        this.bankRouting = bankRouting;
    }

    @Override
    public String toString() {
        return "GetConsultaCuentaPorAliasResponse [" +
                ((owner != null) ? "owner=" + Arrays.toString(owner.toArray()) + ", " : "") +
                ((type != null) ? "type='" + type + "', " : "") +
                ((isActive != null) ? "isActive=" + isActive + ", " : "") +
                ((currency != null) ? "currency='" + currency + "', " : "") +
                ((label != null) ? "label='" + label + "', " : "") +
                ((accountRouting != null) ? "accountRouting=" + accountRouting + ", " : "") +
                ((bankRouting != null) ? "bankRouting=" + bankRouting + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GetConsultaCuentaPorAliasCbuCvuResponse that = (GetConsultaCuentaPorAliasCbuCvuResponse) o;
        return Objects.equals(owner, that.owner) &&
                Objects.equals(type, that.type) &&
                Objects.equals(isActive, that.isActive) &&
                Objects.equals(currency, that.currency) &&
                Objects.equals(label, that.label) &&
                Objects.equals(accountRouting, that.accountRouting) &&
                Objects.equals(bankRouting, that.bankRouting);
    }

    @Override
    public int hashCode() {
        return Objects.hash(owner, type, isActive, currency, label, accountRouting, bankRouting);
    }
}
