package ar.com.sdd.bindapi.io;

import ar.com.sdd.bindapi.model.OriginDebit;
import ar.com.sdd.bindapi.model.To;
import ar.com.sdd.bindapi.model.Value;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PostRealizarTransferenciaDesdeCVURequest implements Serializable {

    @JsonProperty("origin_id")
    private String originId;

    @JsonProperty("origin_debit")
    private OriginDebit originDebit;

    @JsonProperty("to")
    private To to;

    @JsonProperty("value")
    private Value value;

    @JsonProperty("description")
    private String description;

    @JsonProperty("concept")
    private String concept;

    @JsonProperty("emails")
    private List<String> emails;

    public String getOriginId() {
        return originId;
    }

    public void setOriginId(String originId) {
        this.originId = originId;
    }

    public OriginDebit getOriginDebit() {
        return originDebit;
    }

    public void setOriginDebit(OriginDebit originDebit) {
        this.originDebit = originDebit;
    }

    public To getTo() {
        return to;
    }

    public void setTo(To to) {
        this.to = to;
    }

    public Value getValue() {
        return value;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getConcept() {
        return concept;
    }

    public void setConcept(String concept) {
        this.concept = concept;
    }

    public List<String> getEmails() {
        return emails;
    }

    public void setEmails(List<String> emails) {
        this.emails = emails;
    }

    @Override
    public String toString() {
        return "PostRealizarTransferenciaDesdeCVURequest [" +
                ((originId != null) ? "originId='" + originId + "', " : "") +
                ((originDebit != null) ? "originDebit=" + originDebit + ", " : "") +
                ((to != null) ? "to=" + to + ", " : "") +
                ((value != null) ? "value=" + value + ", " : "") +
                ((description != null) ? "description='" + description + "', " : "") +
                ((concept != null) ? "concept='" + concept + "', " : "") +
                ((emails != null) ? "emails=" + Arrays.toString(emails.toArray()) + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PostRealizarTransferenciaDesdeCVURequest that = (PostRealizarTransferenciaDesdeCVURequest) o;
        return Objects.equals(originId, that.originId) &&
                Objects.equals(originDebit, that.originDebit) &&
                Objects.equals(to, that.to) &&
                Objects.equals(value, that.value) &&
                Objects.equals(description, that.description) &&
                Objects.equals(concept, that.concept) &&
                Objects.equals(emails, that.emails);
    }

    @Override
    public int hashCode() {
        return Objects.hash(originId, originDebit, to, value, description, concept, emails);
    }
}
