package ar.com.sdd.bindapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Holding implements Serializable {

    @JsonProperty("document_number")
    private String documentNumber;

    @JsonProperty("name")
    private String name;

    @JsonProperty("document_type")
    private String documentType;

    // Getters and Setters
    public String getDocumentNumber() {
        return documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDocumentType() {
        return documentType;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    @Override
    public String toString() {
        return "IssuedTo [" +
                ((documentNumber != null) ? "documentNumber='" + documentNumber + "', " : "") +
                ((name != null) ? "name='" + name + "', " : "") +
                ((documentType != null) ? "documentType='" + documentType + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Holding issuedTo = (Holding) o;
        return Objects.equals(documentNumber, issuedTo.documentNumber) &&
                Objects.equals(name, issuedTo.name) &&
                Objects.equals(documentType, issuedTo.documentType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(documentNumber, name, documentType);
    }
}
