package ar.com.sdd.bindapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PossibleAction implements Serializable {

    @JsonProperty("action")
    private String action;

    @JsonProperty("reasonLength")
    private Integer reasonLength;

    public String getAction() {
        return action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Integer getReasonLength() {
        return reasonLength;
    }

    public void setReasonLength(Integer reasonLength) {
        this.reasonLength = reasonLength;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PossibleAction that = (PossibleAction) o;
        return Objects.equals(action, that.action) && Objects.equals(reasonLength, that.reasonLength);
    }

    @Override
    public int hashCode() {
        return Objects.hash(action, reasonLength);
    }
}
