package ar.com.sdd.bindapi.io;

import ar.com.sdd.bindapi.model.Account;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class GetConsultaDatosVendedorResponse implements Serializable {

    @JsonProperty("id")
    private String id;

    @JsonProperty("display_name")
    private String displayName;

    @JsonProperty("id_type")
    private String idType;

    @JsonProperty("is_physical_person")
    private Boolean isPhysicalPerson;

    @JsonProperty("emails")
    private List<String> emails;

    @JsonProperty("accounts")
    private List<Account> accounts;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDisplayName() {
        return displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getIdType() {
        return idType;
    }

    public void setIdType(String idType) {
        this.idType = idType;
    }

    public Boolean getPhysicalPerson() {
        return isPhysicalPerson;
    }

    public void setPhysicalPerson(Boolean physicalPerson) {
        isPhysicalPerson = physicalPerson;
    }

    public List<String> getEmails() {
        return emails;
    }

    public void setEmails(List<String> emails) {
        this.emails = emails;
    }

    public List<Account> getAccounts() {
        return accounts;
    }

    public void setAccounts(List<Account> accounts) {
        this.accounts = accounts;
    }

    @Override
    public String toString() {
        return "GetConsultaDatosVendedorResponse [" +
                ((id != null) ? "id='" + id + "', " : "") +
                ((displayName != null) ? "displayName='" + displayName + "', " : "") +
                ((idType != null) ? "idType='" + idType + "', " : "") +
                ((isPhysicalPerson != null) ? "isPhysicalPerson=" + isPhysicalPerson + ", " : "") +
                ((emails != null) ? "emails=" + Arrays.toString(emails.toArray()) + ", " : "") +
                ((accounts != null) ? "accounts=" + Arrays.toString(accounts.toArray()) + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GetConsultaDatosVendedorResponse that = (GetConsultaDatosVendedorResponse) o;
        return Objects.equals(id, that.id) &&
                Objects.equals(displayName, that.displayName) &&
                Objects.equals(idType, that.idType) &&
                Objects.equals(isPhysicalPerson, that.isPhysicalPerson) &&
                Objects.equals(emails, that.emails) &&
                Objects.equals(accounts, that.accounts);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, displayName, idType, isPhysicalPerson, emails, accounts);
    }
}
