package ar.com.sdd.bindapi.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PostAltaModificacionWebhookRequest implements Serializable {

    @JsonProperty("url")
    private String url;

    @JsonProperty("description")
    private String description;

    @JsonProperty("code")
    private String code;

    @JsonProperty("enabled")
    private Boolean enabled;

    @JsonProperty("events")
    private List<String> events;

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Boolean getEnabled() {
        return enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public List<String> getEvents() {
        return events;
    }

    public void setEvents(List<String> events) {
        this.events = events;
    }

    @Override
    public String toString() {
        return "PostAltaModificacionWebhookRequest [" +
                ((url != null) ? "url='" + url + "', " : "") +
                ((description != null) ? "description='" + description + "', " : "") +
                ((code != null) ? "code='" + code + "', " : "") +
                ((enabled != null) ? "enabled=" + enabled + ", " : "") +
                ((events != null) ? "events=" + Arrays.toString(events.toArray()) + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PostAltaModificacionWebhookRequest that = (PostAltaModificacionWebhookRequest) o;
        return Objects.equals(url, that.url) && Objects.equals(description, that.description) && Objects.equals(code, that.code) && Objects.equals(enabled, that.enabled) && Objects.equals(events, that.events);
    }

    @Override
    public int hashCode() {
        return Objects.hash(url, description, code, enabled, events);
    }
}
