package ar.com.sdd.bindapi.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PostAltaModificacionWebhookResponse implements Serializable {

    @JsonProperty("url")
    private String url;

    @JsonProperty("description")
    private String description;

    @JsonProperty("code")
    private String code;

    @JsonProperty("enabled")
    private Boolean enabled;

    @JsonProperty("events")
    private List<String> events;

    @JsonProperty("request_body")
    private String requestBody;

    @JsonProperty("request_headers")
    private String requestHeaders;

    @JsonProperty("response_code")
    private String responseCode;

    @JsonProperty("response_body")
    private String responseBody;

    @JsonProperty("response_headers")
    private String responseHeaders;

    @JsonProperty("error_description")
    private String errorDescription;

    @JsonProperty("connection")
    private Boolean connection;

    @JsonProperty("saved")
    private Boolean saved;

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Boolean getEnabled() {
        return enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public List<String> getEvents() {
        return events;
    }

    public void setEvents(List<String> events) {
        this.events = events;
    }

    public String getRequestBody() {
        return requestBody;
    }

    public void setRequestBody(String requestBody) {
        this.requestBody = requestBody;
    }

    public String getRequestHeaders() {
        return requestHeaders;
    }

    public void setRequestHeaders(String requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    public String getResponseCode() {
        return responseCode;
    }

    public void setResponseCode(String responseCode) {
        this.responseCode = responseCode;
    }

    public String getResponseBody() {
        return responseBody;
    }

    public void setResponseBody(String responseBody) {
        this.responseBody = responseBody;
    }

    public String getResponseHeaders() {
        return responseHeaders;
    }

    public void setResponseHeaders(String responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    public String getErrorDescription() {
        return errorDescription;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public Boolean getConnection() {
        return connection;
    }

    public void setConnection(Boolean connection) {
        this.connection = connection;
    }

    public Boolean getSaved() {
        return saved;
    }

    public void setSaved(Boolean saved) {
        this.saved = saved;
    }

    @Override
    public String toString() {
        return "PostAltaModificacionWebhookResponse [" +
                ((url != null) ? "url='" + url + "', " : "") +
                ((description != null) ? "description='" + description + "', " : "") +
                ((code != null) ? "code='" + code + "', " : "") +
                ((enabled != null) ? "enabled=" + enabled + ", " : "") +
                ((events != null) ? "events=" + Arrays.toString(events.toArray()) + ", " : "") +
                ((requestBody != null) ? "requestBody='" + requestBody + "', " : "") +
                ((requestHeaders != null) ? "requestHeaders='" + requestHeaders + "', " : "") +
                ((responseCode != null) ? "responseCode='" + responseCode + "', " : "") +
                ((responseBody != null) ? "responseBody='" + responseBody + "', " : "") +
                ((responseHeaders != null) ? "responseHeaders='" + responseHeaders + "', " : "") +
                ((errorDescription != null) ? "errorDescription='" + errorDescription + "', " : "") +
                ((connection != null) ? "connection=" + connection + ", " : "") +
                ((saved != null) ? "saved=" + saved + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PostAltaModificacionWebhookResponse that = (PostAltaModificacionWebhookResponse) o;
        return Objects.equals(url, that.url) && Objects.equals(description, that.description) && Objects.equals(code, that.code) && Objects.equals(enabled, that.enabled) && Objects.equals(events, that.events) && Objects.equals(requestBody, that.requestBody) && Objects.equals(requestHeaders, that.requestHeaders) && Objects.equals(responseCode, that.responseCode) && Objects.equals(responseBody, that.responseBody) && Objects.equals(responseHeaders, that.responseHeaders) && Objects.equals(errorDescription, that.errorDescription) && Objects.equals(connection, that.connection) && Objects.equals(saved, that.saved);
    }

    @Override
    public int hashCode() {
        return Objects.hash(url, description, code, enabled, events, requestBody, requestHeaders, responseCode, responseBody, responseHeaders, errorDescription, connection, saved);
    }
}
