package ar.com.sdd.bindapi.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PostAsignarModificarAliasCVURequest implements Serializable {

    @JsonProperty("cuit")
    private String cuit;

    @JsonProperty("cvu")
    private String cvu;

    @JsonProperty("label")
    private String label;

    public String getCuit() {
        return cuit;
    }

    public void setCuit(String cuit) {
        this.cuit = cuit;
    }

    public String getCvu() {
        return cvu;
    }

    public void setCvu(String cvu) {
        this.cvu = cvu;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public String toString() {
        return "PostAsignarModificarAliasCVURequest [" +
                ((cuit != null) ? "cuit='" + cuit + "', " : "") +
                ((cvu != null) ? "cvu='" + cvu + "', " : "") +
                ((label != null) ? "label='" + label + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PostAsignarModificarAliasCVURequest that = (PostAsignarModificarAliasCVURequest) o;
        return Objects.equals(cuit, that.cuit) && Objects.equals(cvu, that.cvu) && Objects.equals(label, that.label);
    }

    @Override
    public int hashCode() {
        return Objects.hash(cuit, cvu, label);
    }
}
