package ar.com.sdd.bindapi.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PostEnvioMensajeWebhookConfiguradoRequest implements Serializable {

    @JsonProperty("id")
    private String id;

    @JsonProperty("object")
    private String object;

    @JsonProperty("dateTime")
    private Date dateTime;

    @JsonProperty("data")
    private Object data;

    @JsonProperty("type")
    private String type;

    @JsonProperty("redeliveries")
    private String redeliveries;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getObject() {
        return object;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public Date getDateTime() {
        return dateTime;
    }

    public void setDateTime(Date dateTime) {
        this.dateTime = dateTime;
    }

    public Object getData() {
        return data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getRedeliveries() {
        return redeliveries;
    }

    public void setRedeliveries(String redeliveries) {
        this.redeliveries = redeliveries;
    }

    @Override
    public String toString() {
        return "PostEnvioMensajeWebhookConfiguradoRequest [" +
                ((id != null) ? "id='" + id + "', " : "") +
                ((object != null) ? "object='" + object + "', " : "") +
                ((dateTime != null) ? "dateTime=" + dateTime + ", " : "") +
                ((data != null) ? "data=" + data + ", " : "") +
                ((type != null) ? "type='" + type + "', " : "") +
                ((redeliveries != null) ? "redeliveries='" + redeliveries + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PostEnvioMensajeWebhookConfiguradoRequest that = (PostEnvioMensajeWebhookConfiguradoRequest) o;
        return Objects.equals(id, that.id) && Objects.equals(object, that.object) && Objects.equals(dateTime, that.dateTime) && Objects.equals(data, that.data) && Objects.equals(type, that.type) && Objects.equals(redeliveries, that.redeliveries);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, object, dateTime, data, type, redeliveries);
    }
}
