package ar.com.sdd.bindapi.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PostLoginResponse implements Serializable {

    @JsonProperty("token")
    private String token;

    @JsonProperty("expires_in")
    private int expiresIn; // int para evitar cast en SimpleCache

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public int getExpiresIn() {
        return expiresIn;
    }

    public void setExpiresIn(int expiresIn) {
        this.expiresIn = expiresIn;
    }

    @Override
    public String toString() {
        return "PostLoginResponse [" +
                ((token != null) ? "token='" + token + "', " : "") +
                "expiresIn=" + expiresIn + ", " +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PostLoginResponse that = (PostLoginResponse) o;
        return expiresIn == that.expiresIn && Objects.equals(token, that.token);
    }

    @Override
    public int hashCode() {
        return Objects.hash(token, expiresIn);
    }
}