package ar.com.sdd.bindapi.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PutAltaBajaCuentaVendedorRequest implements Serializable {

    @JsonProperty("adhered")
    private Boolean adhered;

    public Boolean getAdhered() {
        return adhered;
    }

    public void setAdhered(Boolean adhered) {
        this.adhered = adhered;
    }

    @Override
    public String toString() {
        return "PutAltaBajaCuentaVendedorRequest [" +
                ((adhered != null) ? "adhered=" + adhered + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PutAltaBajaCuentaVendedorRequest that = (PutAltaBajaCuentaVendedorRequest) o;
        return Objects.equals(adhered, that.adhered);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(adhered);
    }
}
