package ar.com.sdd.bindapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Buyer implements Serializable {

    @JsonProperty("cuit")
    private String cuit;

    @JsonProperty("alias")
    private String alias;

    @JsonProperty("cbu")
    private String cbu;

    @JsonProperty("name")
    private String name;

    @JsonProperty("bank_code")
    private String bankCode;

    @JsonProperty("bank_description")
    private String bankDescription;

    public String getCuit() {
        return cuit;
    }

    public void setCuit(String cuit) {
        this.cuit = cuit;
    }

    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getCbu() {
        return cbu;
    }

    public void setCbu(String cbu) {
        this.cbu = cbu;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBankCode() {
        return bankCode;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public String getBankDescription() {
        return bankDescription;
    }

    public void setBankDescription(String bankDescription) {
        this.bankDescription = bankDescription;
    }

    @Override
    public String toString() {
        return "Buyer [" +
                ((cuit != null) ? "cuit='" + cuit + "', " : "") +
                ((alias != null) ? "alias='" + alias + "', " : "") +
                ((cbu != null) ? "cbu='" + cbu + "', " : "") +
                ((name != null) ? "name='" + name + "', " : "") +
                ((bankCode != null) ? "bankCode='" + bankCode + "', " : "") +
                ((bankDescription != null) ? "bankDescription='" + bankDescription + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Buyer buyer = (Buyer) o;
        return Objects.equals(cuit, buyer.cuit) &&
                Objects.equals(alias, buyer.alias) &&
                Objects.equals(cbu, buyer.cbu) &&
                Objects.equals(name, buyer.name) &&
                Objects.equals(bankCode, buyer.bankCode) &&
                Objects.equals(bankDescription, buyer.bankDescription);
    }

    @Override
    public int hashCode() {
        return Objects.hash(cuit, alias, cbu, name, bankCode, bankDescription);
    }
}
