package ar.com.sdd.bindapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Charge implements Serializable {

    @JsonProperty("summary")
    private String summary;

    @JsonProperty("value")
    private Value value;

    public String getSummary() {
        return summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public Value getValue() {
        return value;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return "Charge [" +
                ((summary != null) ? "summary='" + summary + "', " : "") +
                ((value != null) ? "value=" + value + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Charge charge = (Charge) o;
        return Objects.equals(summary, charge.summary) && Objects.equals(value, charge.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(summary, value);
    }
}