package ar.com.sdd.bindapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Check implements Serializable {

    @JsonProperty("has_endorsment_chain")
    private Boolean hasEndorsmentChain;

    @JsonProperty("issuance_code")
    private String issuanceCode;

    @JsonProperty("issued_to")
    private IssuedTo issuedTo;

    @JsonProperty("endorser_cuit")
    private String endorserCuit;

    @JsonProperty("payment_date_due")
    private Boolean paymentDateDue;

    @JsonProperty("channel")
    private String channel;

    @JsonProperty("last_modified_date")
    private String lastModifiedDate;

    @JsonProperty("factoring_enabled")
    private Boolean factoringEnabled;

    @JsonProperty("possible_actions")
    private List<PossibleAction>  possibleActions;

    @JsonProperty("type")
    private String type;

    @JsonProperty("last_modified_date_issuer_account")
    private String lastModifiedDateIssuerAccount;

    @JsonProperty("front_img")
    private String frontImg;

    @JsonProperty("cheque_image_status")
    private String chequeImageStatus;

    @JsonProperty("mode")
    private String mode;

    @JsonProperty("check_number")
    private String checkNumber;

    @JsonProperty("issued_date")
    private String issuedDate;

    @JsonProperty("admission_date")
    private String admissionDate;

    @JsonProperty("id")
    private String id;

    @JsonProperty("back_img")
    private String backImg;

    @JsonProperty("issuer_currency")
    private String issuerCurrency;

    @JsonProperty("payment_date")
    private String paymentDate;

    @JsonProperty("branch_province")
    private String branchProvince;

    @JsonProperty("annulment_reason")
    private String annulmentReason;

    @JsonProperty("issuer_cp")
    private String issuerCp;

    @JsonProperty("issuer_repudiation_reason")
    private String issuerRepudiationReason;

    @JsonProperty("branch_cp")
    private String branchCp;

    @JsonProperty("check_id")
    private String checkId;

    @JsonProperty("endorser_name")
    private String endorserName;

    @JsonProperty("endorsed_to_name")
    private String endorsedToName;

    @JsonProperty("payment_reference")
    private List<PaymentReference> paymentReference;

    @JsonProperty("created_by")
    private String createdBy;

    @JsonProperty("issuer_address")
    private String issuerAddress;

    @JsonProperty("visualization_code")
    private String visualizationCode;

    @JsonProperty("status_detail")
    private String statusDetail;

    @JsonProperty("cmc7")
    private String cmc7;

    @JsonProperty("branch_code")
    private String branchCode;

    @JsonProperty("check_delivered")
    private Boolean checkDelivered;

    @JsonProperty("issuer_sub_account")
    private String issuerSubAccount;

    @JsonProperty("checkbook_number")
    private String checkbookNumber;

    @JsonProperty("payment_reason")
    private String paymentReason;

    @JsonProperty("no_pay_order")
    private Boolean noPayOrder;

    @JsonProperty("status")
    private String status;

    @JsonProperty("endorsed_to_cuit")
    private String endorsedToCuit;

    @JsonProperty("application_type")
    private String applicationType;

    @JsonProperty("concept")
    private String concept;

    @JsonProperty("error")
    private String error;

    @JsonProperty("agreed_check")
    private Boolean agreedCheck;

    @JsonProperty("certificate_issued")
    private Boolean certificateIssued;

    @JsonProperty("currency_code")
    private String currencyCode;

    @JsonProperty("emails")
    private List<String> emails;

    @JsonProperty("holding")
    private Holding holding;

    @JsonProperty("rejects")
    private List<String> rejects;

    @JsonProperty("branch_name")
    private String branchName;

    @JsonProperty("bank_name")
    private String bankName;

    @JsonProperty("endorsments")
    private List<Endorsments> endorsments;

    @JsonProperty("issuer_account")
    private String issuerAccount;

    @JsonProperty("last_update_date")
    private String lastUpdateDate;

    @JsonProperty("bank_code")
    private String bankCode;

    @JsonProperty("amount")
    private Double amount;

    @JsonProperty("resubmitting")
    private Boolean resubmitting;

    @JsonProperty("nature")
    private String nature;

    @JsonProperty("last_modified_by")
    private String lastModifiedBy;

    @JsonProperty("front_image")
    private String frontImage;

    @JsonProperty("signer_name")
    private String signerName;

    @JsonProperty("back_image")
    private String backImage;

    @JsonProperty("group_id")
    private String groupId;

    @JsonProperty("branch_address")
    private String branchAddress;

    @JsonProperty("issuer_cbu")
    private String issuerCbu;

    @JsonProperty("created_date")
    private String createdDate;

    @JsonProperty("application_number")
    private String applicationNumber;

    @JsonProperty("agreement_requesting")
    private Boolean agreementRequesting;

    @JsonProperty("signer_cuit")
    private String signerCuit;

    @JsonProperty("account")
    private String account;

    @JsonProperty("endorsement_repudiation")
    private Boolean endorsementRepudiation;

    // Getters and Setters
    public Boolean getHasEndorsmentChain() {
        return hasEndorsmentChain;
    }

    public void setHasEndorsmentChain(Boolean hasEndorsmentChain) {
        this.hasEndorsmentChain = hasEndorsmentChain;
    }

    public String getIssuanceCode() {
        return issuanceCode;
    }

    public void setIssuanceCode(String issuanceCode) {
        this.issuanceCode = issuanceCode;
    }

    public IssuedTo getIssuedTo() {
        return issuedTo;
    }

    public void setIssuedTo(IssuedTo issuedTo) {
        this.issuedTo = issuedTo;
    }

    public String getEndorserCuit() {
        return endorserCuit;
    }

    public void setEndorserCuit(String endorserCuit) {
        this.endorserCuit = endorserCuit;
    }

    public Boolean getPaymentDateDue() {
        return paymentDateDue;
    }

    public void setPaymentDateDue(Boolean paymentDateDue) {
        this.paymentDateDue = paymentDateDue;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getLastModifiedDate() {
        return lastModifiedDate;
    }

    public void setLastModifiedDate(String lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public Boolean getFactoringEnabled() {
        return factoringEnabled;
    }

    public void setFactoringEnabled(Boolean factoringEnabled) {
        this.factoringEnabled = factoringEnabled;
    }

    public List<PossibleAction> getPossibleActions() {
        return possibleActions;
    }

    public void setPossibleActions(List<PossibleAction> possibleActions) {
        this.possibleActions = possibleActions;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getLastModifiedDateIssuerAccount() {
        return lastModifiedDateIssuerAccount;
    }

    public void setLastModifiedDateIssuerAccount(String lastModifiedDateIssuerAccount) {
        this.lastModifiedDateIssuerAccount = lastModifiedDateIssuerAccount;
    }

    public String getFrontImg() {
        return frontImg;
    }

    public void setFrontImg(String frontImg) {
        this.frontImg = frontImg;
    }

    public String getChequeImageStatus() {
        return chequeImageStatus;
    }

    public void setChequeImageStatus(String chequeImageStatus) {
        this.chequeImageStatus = chequeImageStatus;
    }

    public String getMode() {
        return mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getCheckNumber() {
        return checkNumber;
    }

    public void setCheckNumber(String checkNumber) {
        this.checkNumber = checkNumber;
    }

    public String getIssuedDate() {
        return issuedDate;
    }

    public void setIssuedDate(String issuedDate) {
        this.issuedDate = issuedDate;
    }

    public String getAdmissionDate() {
        return admissionDate;
    }

    public void setAdmissionDate(String admissionDate) {
        this.admissionDate = admissionDate;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getBackImg() {
        return backImg;
    }

    public void setBackImg(String backImg) {
        this.backImg = backImg;
    }

    public String getIssuerCurrency() {
        return issuerCurrency;
    }

    public void setIssuerCurrency(String issuerCurrency) {
        this.issuerCurrency = issuerCurrency;
    }

    public String getPaymentDate() {
        return paymentDate;
    }

    public void setPaymentDate(String paymentDate) {
        this.paymentDate = paymentDate;
    }

    public String getBranchProvince() {
        return branchProvince;
    }

    public void setBranchProvince(String branchProvince) {
        this.branchProvince = branchProvince;
    }

    public String getAnnulmentReason() {
        return annulmentReason;
    }

    public void setAnnulmentReason(String annulmentReason) {
        this.annulmentReason = annulmentReason;
    }

    public String getIssuerCp() {
        return issuerCp;
    }

    public void setIssuerCp(String issuerCp) {
        this.issuerCp = issuerCp;
    }

    public String getIssuerRepudiationReason() {
        return issuerRepudiationReason;
    }

    public void setIssuerRepudiationReason(String issuerRepudiationReason) {
        this.issuerRepudiationReason = issuerRepudiationReason;
    }

    public String getBranchCp() {
        return branchCp;
    }

    public void setBranchCp(String branchCp) {
        this.branchCp = branchCp;
    }

    public String getCheckId() {
        return checkId;
    }

    public void setCheckId(String checkId) {
        this.checkId = checkId;
    }

    public String getEndorserName() {
        return endorserName;
    }

    public void setEndorserName(String endorserName) {
        this.endorserName = endorserName;
    }

    public String getEndorsedToName() {
        return endorsedToName;
    }

    public void setEndorsedToName(String endorsedToName) {
        this.endorsedToName = endorsedToName;
    }

    public List<PaymentReference> getPaymentReference() {
        return paymentReference;
    }

    public void setPaymentReference(List<PaymentReference> paymentReference) {
        this.paymentReference = paymentReference;
    }

    public String getCreatedBy() {
        return createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getIssuerAddress() {
        return issuerAddress;
    }

    public void setIssuerAddress(String issuerAddress) {
        this.issuerAddress = issuerAddress;
    }

    public String getVisualizationCode() {
        return visualizationCode;
    }

    public void setVisualizationCode(String visualizationCode) {
        this.visualizationCode = visualizationCode;
    }

    public String getStatusDetail() {
        return statusDetail;
    }

    public void setStatusDetail(String statusDetail) {
        this.statusDetail = statusDetail;
    }

    public String getCmc7() {
        return cmc7;
    }

    public void setCmc7(String cmc7) {
        this.cmc7 = cmc7;
    }

    public String getBranchCode() {
        return branchCode;
    }

    public void setBranchCode(String branchCode) {
        this.branchCode = branchCode;
    }

    public Boolean getCheckDelivered() {
        return checkDelivered;
    }

    public void setCheckDelivered(Boolean checkDelivered) {
        this.checkDelivered = checkDelivered;
    }

    public String getIssuerSubAccount() {
        return issuerSubAccount;
    }

    public void setIssuerSubAccount(String issuerSubAccount) {
        this.issuerSubAccount = issuerSubAccount;
    }

    public String getCheckbookNumber() {
        return checkbookNumber;
    }

    public void setCheckbookNumber(String checkbookNumber) {
        this.checkbookNumber = checkbookNumber;
    }

    public String getPaymentReason() {
        return paymentReason;
    }

    public void setPaymentReason(String paymentReason) {
        this.paymentReason = paymentReason;
    }

    public Boolean getNoPayOrder() {
        return noPayOrder;
    }

    public void setNoPayOrder(Boolean noPayOrder) {
        this.noPayOrder = noPayOrder;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getEndorsedToCuit() {
        return endorsedToCuit;
    }

    public void setEndorsedToCuit(String endorsedToCuit) {
        this.endorsedToCuit = endorsedToCuit;
    }

    public String getApplicationType() {
        return applicationType;
    }

    public void setApplicationType(String applicationType) {
        this.applicationType = applicationType;
    }

    public String getConcept() {
        return concept;
    }

    public void setConcept(String concept) {
        this.concept = concept;
    }

    public String getError() {
        return error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public Boolean getAgreedCheck() {
        return agreedCheck;
    }

    public void setAgreedCheck(Boolean agreedCheck) {
        this.agreedCheck = agreedCheck;
    }

    public Boolean getCertificateIssued() {
        return certificateIssued;
    }

    public void setCertificateIssued(Boolean certificateIssued) {
        this.certificateIssued = certificateIssued;
    }

    public String getCurrencyCode() {
        return currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public List<String> getEmails() {
        return emails;
    }

    public void setEmails(List<String> emails) {
        this.emails = emails;
    }

    public Holding getHolding() {
        return holding;
    }

    public void setHolding(Holding holding) {
        this.holding = holding;
    }

    public List<String> getRejects() {
        return rejects;
    }

    public void setRejects(List<String> rejects) {
        this.rejects = rejects;
    }

    public String getBranchName() {
        return branchName;
    }

    public void setBranchName(String branchName) {
        this.branchName = branchName;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public List<Endorsments> getEndorsments() {
        return endorsments;
    }

    public void setEndorsments(List<Endorsments> endorsments) {
        this.endorsments = endorsments;
    }

    public String getIssuerAccount() {
        return issuerAccount;
    }

    public void setIssuerAccount(String issuerAccount) {
        this.issuerAccount = issuerAccount;
    }

    public String getLastUpdateDate() {
        return lastUpdateDate;
    }

    public void setLastUpdateDate(String lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate;
    }

    public String getBankCode() {
        return bankCode;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public Double getAmount() {
        return amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public Boolean getResubmitting() {
        return resubmitting;
    }

    public void setResubmitting(Boolean resubmitting) {
        this.resubmitting = resubmitting;
    }

    public String getNature() {
        return nature;
    }

    public void setNature(String nature) {
        this.nature = nature;
    }

    public String getLastModifiedBy() {
        return lastModifiedBy;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public String getFrontImage() {
        return frontImage;
    }

    public void setFrontImage(String frontImage) {
        this.frontImage = frontImage;
    }

    public String getSignerName() {
        return signerName;
    }

    public void setSignerName(String signerName) {
        this.signerName = signerName;
    }

    public String getBackImage() {
        return backImage;
    }

    public void setBackImage(String backImage) {
        this.backImage = backImage;
    }

    public String getGroupId() {
        return groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getBranchAddress() {
        return branchAddress;
    }

    public void setBranchAddress(String branchAddress) {
        this.branchAddress = branchAddress;
    }

    public String getIssuerCbu() {
        return issuerCbu;
    }

    public void setIssuerCbu(String issuerCbu) {
        this.issuerCbu = issuerCbu;
    }

    public String getCreatedDate() {
        return createdDate;
    }

    public void setCreatedDate(String createdDate) {
        this.createdDate = createdDate;
    }

    public String getApplicationNumber() {
        return applicationNumber;
    }

    public void setApplicationNumber(String applicationNumber) {
        this.applicationNumber = applicationNumber;
    }

    public Boolean getAgreementRequesting() {
        return agreementRequesting;
    }

    public void setAgreementRequesting(Boolean agreementRequesting) {
        this.agreementRequesting = agreementRequesting;
    }

    public String getSignerCuit() {
        return signerCuit;
    }

    public void setSignerCuit(String signerCuit) {
        this.signerCuit = signerCuit;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public Boolean getEndorsementRepudiation() {
        return endorsementRepudiation;
    }

    public void setEndorsementRepudiation(Boolean endorsementRepudiation) {
        this.endorsementRepudiation = endorsementRepudiation;
    }

    @Override
    public String toString() {
        return "Check [" +
                ((hasEndorsmentChain != null) ? "hasEndorsmentChain=" + hasEndorsmentChain + ", " : "") +
                ((issuanceCode != null) ? "issuanceCode='" + issuanceCode + "', " : "") +
                ((issuedTo != null) ? "issuedTo=" + issuedTo + ", " : "") +
                ((endorserCuit != null) ? "endorserCuit='" + endorserCuit + "', " : "") +
                ((paymentDateDue != null) ? "paymentDateDue=" + paymentDateDue + ", " : "") +
                ((channel != null) ? "channel='" + channel + "', " : "") +
                ((lastModifiedDate != null) ? "lastModifiedDate='" + lastModifiedDate + "', " : "") +
                ((factoringEnabled != null) ? "factoringEnabled=" + factoringEnabled + ", " : "") +
                ((possibleActions != null) ? "possibleActions=" + Arrays.toString(possibleActions.toArray()) + ", " : "") +
                ((type != null) ? "type='" + type + "', " : "") +
                ((lastModifiedDateIssuerAccount != null) ? "lastModifiedDateIssuerAccount='" + lastModifiedDateIssuerAccount + "', " : "") +
                ((frontImg != null) ? "frontImg='" + frontImg + "', " : "") +
                ((chequeImageStatus != null) ? "chequeImageStatus='" + chequeImageStatus + "', " : "") +
                ((mode != null) ? "mode='" + mode + "', " : "") +
                ((checkNumber != null) ? "checkNumber='" + checkNumber + "', " : "") +
                ((issuedDate != null) ? "issuedDate='" + issuedDate + "', " : "") +
                ((admissionDate != null) ? "admissionDate='" + admissionDate + "', " : "") +
                ((id != null) ? "id='" + id + "', " : "") +
                ((backImg != null) ? "backImg='" + backImg + "', " : "") +
                ((issuerCurrency != null) ? "issuerCurrency='" + issuerCurrency + "', " : "") +
                ((paymentDate != null) ? "paymentDate='" + paymentDate + "', " : "") +
                ((branchProvince != null) ? "branchProvince='" + branchProvince + "', " : "") +
                ((annulmentReason != null) ? "annulmentReason='" + annulmentReason + "', " : "") +
                ((issuerCp != null) ? "issuerCp='" + issuerCp + "', " : "") +
                ((issuerRepudiationReason != null) ? "issuerRepudiationReason='" + issuerRepudiationReason + "', " : "") +
                ((branchCp != null) ? "branchCp='" + branchCp + "', " : "") +
                ((checkId != null) ? "checkId='" + checkId + "', " : "") +
                ((endorserName != null) ? "endorserName='" + endorserName + "', " : "") +
                ((endorsedToName != null) ? "endorsedToName='" + endorsedToName + "', " : "") +
                ((paymentReference != null) ? "paymentReference=" + Arrays.toString(paymentReference.toArray()) + ", " : "") +
                ((createdBy != null) ? "createdBy='" + createdBy + "', " : "") +
                ((issuerAddress != null) ? "issuerAddress='" + issuerAddress + "', " : "") +
                ((visualizationCode != null) ? "visualizationCode='" + visualizationCode + "', " : "") +
                ((statusDetail != null) ? "statusDetail='" + statusDetail + "', " : "") +
                ((cmc7 != null) ? "cmc7='" + cmc7 + "', " : "") +
                ((branchCode != null) ? "branchCode='" + branchCode + "', " : "") +
                ((checkDelivered != null) ? "checkDelivered='" + checkDelivered + "', " : "") +
                ((issuerSubAccount != null) ? "issuerSubAccount='" + issuerSubAccount + "', " : "") +
                ((checkbookNumber != null) ? "checkbookNumber='" + checkbookNumber + "', " : "") +
                ((paymentReason != null) ? "paymentReason='" + paymentReason + "', " : "") +
                ((noPayOrder != null) ? "noPayOrder=" + noPayOrder + ", " : "") +
                ((status != null) ? "status='" + status + "', " : "") +
                ((endorsedToCuit != null) ? "endorsedToCuit='" + endorsedToCuit + "', " : "") +
                ((applicationType != null) ? "applicationType='" + applicationType + "', " : "") +
                ((concept != null) ? "concept='" + concept + "', " : "") +
                ((error != null) ? "error='" + error + "', " : "") +
                ((agreedCheck != null) ? "agreedCheck=" + agreedCheck + ", " : "") +
                ((certificateIssued != null) ? "certificateIssued=" + certificateIssued + ", " : "") +
                ((currencyCode != null) ? "currencyCode='" + currencyCode + "', " : "") +
                ((emails != null) ? "emails=" + Arrays.toString(emails.toArray()) + ", " : "") +
                ((holding != null) ? "holding=" + holding + ", " : "") +
                ((rejects != null) ? "rejects=" + Arrays.toString(rejects.toArray()) + ", " : "") +
                ((branchName != null) ? "branchName='" + branchName + "', " : "") +
                ((bankName != null) ? "bankName='" + bankName + "', " : "") +
                ((endorsments != null) ? "endorsments=" + Arrays.toString(endorsments.toArray()) + ", " : "") +
                ((issuerAccount != null) ? "issuerAccount='" + issuerAccount + "', " : "") +
                ((lastUpdateDate != null) ? "lastUpdateDate='" + lastUpdateDate + "', " : "") +
                ((bankCode != null) ? "bankCode='" + bankCode + "', " : "") +
                ((amount != null) ? "amount=" + amount + ", " : "") +
                ((resubmitting != null) ? "resubmitting=" + resubmitting + ", " : "") +
                ((nature != null) ? "nature='" + nature + "', " : "") +
                ((lastModifiedBy != null) ? "lastModifiedBy='" + lastModifiedBy + "', " : "") +
                ((frontImage != null) ? "frontImage='" + frontImage + "', " : "") +
                ((signerName != null) ? "signerName='" + signerName + "', " : "") +
                ((backImage != null) ? "backImage='" + backImage + "', " : "") +
                ((groupId != null) ? "groupId='" + groupId + "', " : "") +
                ((branchAddress != null) ? "branchAddress='" + branchAddress + "', " : "") +
                ((issuerCbu != null) ? "issuerCbu='" + issuerCbu + "', " : "") +
                ((createdDate != null) ? "createdDate='" + createdDate + "', " : "") +
                ((applicationNumber != null) ? "applicationNumber='" + applicationNumber + "', " : "") +
                ((agreementRequesting != null) ? "agreementRequesting=" + agreementRequesting + ", " : "") +
                ((signerCuit != null) ? "signerCuit='" + signerCuit + "', " : "") +
                ((account != null) ? "account='" + account + "', " : "") +
                ((endorsementRepudiation != null) ? "endorsementRepudiation=" + endorsementRepudiation + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Check check = (Check) o;
        return Objects.equals(amount, check.amount) &&
                Objects.equals(hasEndorsmentChain, check.hasEndorsmentChain) &&
                Objects.equals(issuanceCode, check.issuanceCode) &&
                Objects.equals(issuedTo, check.issuedTo) &&
                Objects.equals(endorserCuit, check.endorserCuit) &&
                Objects.equals(paymentDateDue, check.paymentDateDue) &&
                Objects.equals(channel, check.channel) &&
                Objects.equals(lastModifiedDate, check.lastModifiedDate) &&
                Objects.equals(factoringEnabled, check.factoringEnabled) &&
                Objects.equals(possibleActions, check.possibleActions) &&
                Objects.equals(type, check.type) &&
                Objects.equals(lastModifiedDateIssuerAccount, check.lastModifiedDateIssuerAccount) &&
                Objects.equals(frontImg, check.frontImg) &&
                Objects.equals(chequeImageStatus, check.chequeImageStatus) &&
                Objects.equals(mode, check.mode) &&
                Objects.equals(checkNumber, check.checkNumber) &&
                Objects.equals(issuedDate, check.issuedDate) &&
                Objects.equals(admissionDate, check.admissionDate) &&
                Objects.equals(id, check.id) &&
                Objects.equals(backImg, check.backImg) &&
                Objects.equals(issuerCurrency, check.issuerCurrency) &&
                Objects.equals(paymentDate, check.paymentDate) &&
                Objects.equals(branchProvince, check.branchProvince) &&
                Objects.equals(annulmentReason, check.annulmentReason) &&
                Objects.equals(issuerCp, check.issuerCp) &&
                Objects.equals(issuerRepudiationReason, check.issuerRepudiationReason) &&
                Objects.equals(branchCp, check.branchCp) &&
                Objects.equals(checkId, check.checkId) &&
                Objects.equals(endorserName, check.endorserName) &&
                Objects.equals(endorsedToName, check.endorsedToName) &&
                Objects.equals(paymentReference, check.paymentReference) &&
                Objects.equals(createdBy, check.createdBy) &&
                Objects.equals(issuerAddress, check.issuerAddress) &&
                Objects.equals(visualizationCode, check.visualizationCode) &&
                Objects.equals(statusDetail, check.statusDetail) &&
                Objects.equals(cmc7, check.cmc7) &&
                Objects.equals(branchCode, check.branchCode) &&
                Objects.equals(checkDelivered, check.checkDelivered) &&
                Objects.equals(issuerSubAccount, check.issuerSubAccount) &&
                Objects.equals(checkbookNumber, check.checkbookNumber) &&
                Objects.equals(paymentReason, check.paymentReason) &&
                Objects.equals(noPayOrder, check.noPayOrder) &&
                Objects.equals(status, check.status) &&
                Objects.equals(endorsedToCuit, check.endorsedToCuit) &&
                Objects.equals(applicationType, check.applicationType) &&
                Objects.equals(concept, check.concept) &&
                Objects.equals(error, check.error) &&
                Objects.equals(agreedCheck, check.agreedCheck) &&
                Objects.equals(certificateIssued, check.certificateIssued) &&
                Objects.equals(currencyCode, check.currencyCode) &&
                Objects.equals(emails, check.emails) &&
                Objects.equals(holding, check.holding) &&
                Objects.equals(rejects, check.rejects) &&
                Objects.equals(branchName, check.branchName) &&
                Objects.equals(bankName, check.bankName) &&
                Objects.equals(endorsments, check.endorsments) &&
                Objects.equals(issuerAccount, check.issuerAccount) &&
                Objects.equals(lastUpdateDate, check.lastUpdateDate) &&
                Objects.equals(bankCode, check.bankCode) &&
                Objects.equals(resubmitting, check.resubmitting) &&
                Objects.equals(nature, check.nature) &&
                Objects.equals(lastModifiedBy, check.lastModifiedBy) &&
                Objects.equals(frontImage, check.frontImage) &&
                Objects.equals(signerName, check.signerName) &&
                Objects.equals(backImage, check.backImage) &&
                Objects.equals(groupId, check.groupId) &&
                Objects.equals(branchAddress, check.branchAddress) &&
                Objects.equals(issuerCbu, check.issuerCbu) &&
                Objects.equals(createdDate, check.createdDate) &&
                Objects.equals(applicationNumber, check.applicationNumber) &&
                Objects.equals(agreementRequesting, check.agreementRequesting) &&
                Objects.equals(signerCuit, check.signerCuit) &&
                Objects.equals(account, check.account) &&
                Objects.equals(endorsementRepudiation, check.endorsementRepudiation);
    }

    @Override
    public int hashCode() {
        return Objects.hash(hasEndorsmentChain, issuanceCode, issuedTo, endorserCuit, paymentDateDue, channel, lastModifiedDate, factoringEnabled, possibleActions, type, lastModifiedDateIssuerAccount, frontImg, chequeImageStatus, mode, checkNumber, issuedDate, admissionDate, id, backImg, issuerCurrency, paymentDate, branchProvince, annulmentReason, issuerCp, issuerRepudiationReason, branchCp, checkId, endorserName, endorsedToName, paymentReference, createdBy, issuerAddress, visualizationCode, statusDetail, cmc7, branchCode, checkDelivered, issuerSubAccount, checkbookNumber, paymentReason, noPayOrder, status, endorsedToCuit, applicationType, concept, error, agreedCheck, certificateIssued, currencyCode, emails, holding, rejects, branchName, bankName, endorsments, issuerAccount, lastUpdateDate, bankCode, amount, resubmitting, nature, lastModifiedBy, frontImage, signerName, backImage, groupId, branchAddress, issuerCbu, createdDate, applicationNumber, agreementRequesting, signerCuit, account, endorsementRepudiation);
    }
}