package ar.com.sdd.bindapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Details implements Serializable {

    @JsonProperty("origin_id")
    public String originId;

    @JsonProperty("check")
    public Check check;

    @JsonProperty("buyer")
    public Buyer buyer;

    @JsonProperty("preauthorized")
    public Boolean preauthorized;

    @JsonProperty("seller_cuit")
    public String sellerCuit;

    @JsonProperty("seller_account_label")
    public String sellerAccountLabel;

    @JsonProperty("seller_account_cbu")
    public String sellerAccountCBU;

    @JsonProperty("buyer_account_cbu")
    public String buyerAccountCBU;

    @JsonProperty("buyer_cuit")
    public String buyerCuit;

    @JsonProperty("buyer_account_label")
    public String buyerAccountLabel;

    @JsonProperty("concept")
    public String concept;

    @JsonProperty("description")
    public String description;

    @JsonProperty("provision")
    public String provision;

    @JsonProperty("provision_reference")
    public String provisionReference;

    @JsonProperty("origin_debit")
    public OriginDebit originDebit;

    @JsonProperty("origin_credit")
    public OriginCredit originCredit;



    public String getOriginId() {
        return originId;
    }

    public void setOriginId(String originId) {
        this.originId = originId;
    }

    public Check getCheck() {
        return check;
    }

    public void setCheck(Check check) {
        this.check = check;
    }

    public Buyer getBuyer() {
        return buyer;
    }

    public void setBuyer(Buyer buyer) {
        this.buyer = buyer;
    }

    public Boolean getPreauthorized() {
        return preauthorized;
    }

    public void setPreauthorized(Boolean preauthorized) {
        this.preauthorized = preauthorized;
    }

    public String getSellerCuit() {
        return sellerCuit;
    }

    public void setSellerCuit(String sellerCuit) {
        this.sellerCuit = sellerCuit;
    }

    public String getSellerAccountLabel() {
        return sellerAccountLabel;
    }

    public void setSellerAccountLabel(String sellerAccountLabel) {
        this.sellerAccountLabel = sellerAccountLabel;
    }

    public String getSellerAccountCBU() {
        return sellerAccountCBU;
    }

    public void setSellerAccountCBU(String sellerAccountCBU) {
        this.sellerAccountCBU = sellerAccountCBU;
    }

    public String getBuyerAccountCBU() {
        return buyerAccountCBU;
    }

    public void setBuyerAccountCBU(String buyerAccountCBU) {
        this.buyerAccountCBU = buyerAccountCBU;
    }

    public String getBuyerCuit() {
        return buyerCuit;
    }

    public void setBuyerCuit(String buyerCuit) {
        this.buyerCuit = buyerCuit;
    }

    public String getBuyerAccountLabel() {
        return buyerAccountLabel;
    }

    public void setBuyerAccountLabel(String buyerAccountLabel) {
        this.buyerAccountLabel = buyerAccountLabel;
    }

    public String getConcept() {
        return concept;
    }

    public void setConcept(String concept) {
        this.concept = concept;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getProvision() {
        return provision;
    }

    public void setProvision(String provision) {
        this.provision = provision;
    }

    public String getProvisionReference() {
        return provisionReference;
    }

    public void setProvisionReference(String provisionReference) {
        this.provisionReference = provisionReference;
    }

    public OriginDebit getOriginDebit() {
        return originDebit;
    }

    public void setOriginDebit(OriginDebit originDebit) {
        this.originDebit = originDebit;
    }

    @Override
    public String toString() {
        return "Details [" +
                ((originId != null) ? "originId='" + originId + "', " : "") +
                ((check != null) ? "check=" + check + ", " : "") +
                ((buyer != null) ? "buyer=" + buyer + ", " : "") +
                ((preauthorized != null) ? "preauthorized=" + preauthorized + ", " : "") +
                ((sellerCuit != null) ? "sellerCuit='" + sellerCuit + "', " : "") +
                ((sellerAccountLabel != null) ? "sellerAccountLabel='" + sellerAccountLabel + "', " : "") +
                ((sellerAccountCBU != null) ? "sellerAccountCBU='" + sellerAccountCBU + "', " : "") +
                ((buyerAccountCBU != null) ? "buyerAccountCBU='" + buyerAccountCBU + "', " : "") +
                ((buyerCuit != null) ? "buyerCuit='" + buyerCuit + "', " : "") +
                ((buyerAccountLabel != null) ? "buyerAccountLabel='" + buyerAccountLabel + "', " : "") +
                ((concept != null) ? "concept='" + concept + "', " : "") +
                ((description != null) ? "description='" + description + "', " : "") +
                ((provision != null) ? "provision='" + provision + "', " : "") +
                ((provisionReference != null) ? "provisionReference='" + provisionReference + "', " : "") +
                ((originDebit != null) ? "originDebit=" + originDebit + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Details details = (Details) o;
        return Objects.equals(originId, details.originId) &&
                Objects.equals(check, details.check) &&
                Objects.equals(buyer, details.buyer) &&
                Objects.equals(preauthorized, details.preauthorized) &&
                Objects.equals(sellerCuit, details.sellerCuit) &&
                Objects.equals(sellerAccountLabel, details.sellerAccountLabel) &&
                Objects.equals(sellerAccountCBU, details.sellerAccountCBU) &&
                Objects.equals(buyerAccountCBU, details.buyerAccountCBU) &&
                Objects.equals(buyerCuit, details.buyerCuit) &&
                Objects.equals(buyerAccountLabel, details.buyerAccountLabel) &&
                Objects.equals(concept, details.concept) &&
                Objects.equals(description, details.description) &&
                Objects.equals(provision, details.provision) &&
                Objects.equals(provisionReference, details.provisionReference) &&
                Objects.equals(originDebit, details.originDebit);
    }

    @Override
    public int hashCode() {
        return Objects.hash(originId, check, buyer, preauthorized, sellerCuit, sellerAccountLabel, sellerAccountCBU, buyerAccountCBU, buyerCuit,
                buyerAccountLabel, concept, description, provision, provisionReference, originDebit);
    }
}