package ar.com.sdd.bindapi.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Transaction implements Serializable {

    @JsonProperty("id")
    private String id;

    @JsonProperty("type")
    private String type;

    @JsonProperty("from")
    private From from;

    @JsonProperty("details")
    private Details details;

    @JsonProperty("transaction_ids")
    private List<String> transactionIds;

    @JsonProperty("status")
    private String status;

    @JsonProperty("start_date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX", timezone = "GMT-03:00")
    private Date startDate;

    @JsonProperty("end_date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX", timezone = "GMT-03:00")
    private Date endDate;

    @JsonProperty("charge")
    private Charge charge;

    @JsonProperty("challenge")
    private Boolean challenge;

    @JsonProperty("status_description")
    private String statusDescription;

    @JsonProperty("counterparty")
    private Counterparty counterparty;

    @JsonProperty("business_date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX", timezone = "GMT-03:00")
    private Date businessDate;

    // Getters and Setters
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public From getFrom() {
        return from;
    }

    public void setFrom(From from) {
        this.from = from;
    }

    public Details getDetails() {
        return details;
    }

    public void setDetails(Details details) {
        this.details = details;
    }

    public List<String> getTransactionIds() {
        return transactionIds;
    }

    public void setTransactionIds(List<String> transactionIds) {
        this.transactionIds = transactionIds;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Charge getCharge() {
        return charge;
    }

    public void setCharge(Charge charge) {
        this.charge = charge;
    }

    public Boolean getChallenge() {
        return challenge;
    }

    public void setChallenge(Boolean challenge) {
        this.challenge = challenge;
    }

    public String getStatusDescription() {
        return statusDescription;
    }

    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }

    public Counterparty getCounterparty() {
        return counterparty;
    }

    public void setCounterparty(Counterparty counterparty) {
        this.counterparty = counterparty;
    }

    public Date getBusinessDate() {
        return businessDate;
    }

    public void setBusinessDate(Date businessDate) {
        this.businessDate = businessDate;
    }

    @Override
    public String toString() {
        return "Transaction [" +
                ((id != null) ? "id='" + id + "', " : "") +
                ((type != null) ? "type='" + type + "', " : "") +
                ((from != null) ? "from=" + from + ", " : "") +
                ((details != null) ? "details=" + details + ", " : "") +
                ((transactionIds != null) ? "transactionIds=" + Arrays.toString(transactionIds.toArray()) + ", " : "") +
                ((status != null) ? "status='" + status + "', " : "") +
                ((startDate != null) ? "startDate='" + startDate + "', " : "") +
                ((endDate != null) ? "endDate='" + endDate + "', " : "") +
                ((charge != null) ? "charge=" + charge + ", " : "") +
                ((challenge != null) ? "challenge=" + challenge + ", " : "") +
                ((statusDescription != null) ? "statusDescription='" + statusDescription + "', " : "") +
                ((counterparty != null) ? "counterparty=" + counterparty + ", " : "") +
                ((businessDate != null) ? "businessDate=" + businessDate : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Transaction that = (Transaction) o;
        return Objects.equals(id, that.id) && Objects.equals(type, that.type) && Objects.equals(from, that.from) && Objects.equals(details, that.details) && Objects.equals(transactionIds, that.transactionIds) && Objects.equals(status, that.status) && Objects.equals(startDate, that.startDate) && Objects.equals(endDate, that.endDate) && Objects.equals(charge, that.charge) && Objects.equals(challenge, that.challenge) && Objects.equals(statusDescription, that.statusDescription) && Objects.equals(counterparty, that.counterparty) && Objects.equals(businessDate, that.businessDate);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, type, from, details, transactionIds, status, startDate, endDate, charge, challenge, statusDescription, counterparty, businessDate);
    }
}