/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.bindapi.core;

import ar.com.sdd.bindapi.core.BindApiConnectorContext;
import ar.com.sdd.bindapi.io.CommonError;
import ar.com.sdd.bindapi.io.DeleteBajaCVUResponse;
import ar.com.sdd.bindapi.io.DeleteEliminarPedidoDebinResponse;
import ar.com.sdd.bindapi.io.DeleteEliminarWebhookResponse;
import ar.com.sdd.bindapi.io.GetConsultaCuentaPorAliasCbuCvuResponse;
import ar.com.sdd.bindapi.io.GetConsultaDatosVendedorResponse;
import ar.com.sdd.bindapi.io.GetInformaNovedadesDeEcheqs;
import ar.com.sdd.bindapi.io.GetListadoWebhooksResponse;
import ar.com.sdd.bindapi.io.PostABMPedidoDeRecurrenciaDeDebinRequest;
import ar.com.sdd.bindapi.io.PostAltaCVUClienteRequest;
import ar.com.sdd.bindapi.io.PostAltaCVUClienteResponse;
import ar.com.sdd.bindapi.io.PostAltaModificacionWebhookRequest;
import ar.com.sdd.bindapi.io.PostAltaModificacionWebhookResponse;
import ar.com.sdd.bindapi.io.PostAsignarModificarAliasCVURequest;
import ar.com.sdd.bindapi.io.PostAsignarModificarAliasCVUResponse;
import ar.com.sdd.bindapi.io.PostCrearPedidoDebinRequest;
import ar.com.sdd.bindapi.io.PostCrearPedidoDebinResponse;
import ar.com.sdd.bindapi.io.PostEmitirChequeRequest;
import ar.com.sdd.bindapi.io.PostEmitirChequeResponse;
import ar.com.sdd.bindapi.io.PostEnvioMensajeWebhookConfiguradoRequest;
import ar.com.sdd.bindapi.io.PostEnvioMensajeWebhookConfiguradoResponse;
import ar.com.sdd.bindapi.io.PostLoginRequest;
import ar.com.sdd.bindapi.io.PostLoginResponse;
import ar.com.sdd.bindapi.io.PostRealizarTransferenciaDesdeCVURequest;
import ar.com.sdd.bindapi.io.PutAltaBajaCuentaVendedorRequest;
import ar.com.sdd.bindapi.io.PutAltaBajaCuentaVendedorResponse;
import ar.com.sdd.bindapi.io.PutGestionarChequeRequest;
import ar.com.sdd.bindapi.io.PutGestionarChequeResponse;
import ar.com.sdd.bindapi.io.PutModificarCVUClienteRequest;
import ar.com.sdd.bindapi.io.PutModificarCVUClienteResponse;
import ar.com.sdd.bindapi.model.Account;
import ar.com.sdd.bindapi.model.Transaction;
import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.util.DateUtil;
import ar.com.sdd.commons.util.SimpleCache;
import ar.com.sdd.commons.util.SimpleCacheManager;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.client.Invocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BindApiConnector
implements RestSecurityManager {
    private static final Logger log = LogManager.getLogger(BindApiConnector.class);
    private final RestConnector connector;
    private final String username;
    private final String password;
    private boolean doingLogin = false;
    private final String baseUrl;
    private final boolean isSandbox;
    private final String sandboxAccount;
    private final Map<String, Object> headers = new HashMap<String, Object>();

    public BindApiConnector(BindApiConnectorContext context) {
        this.username = context.getUsername();
        this.password = context.getPassword();
        this.baseUrl = context.getBaseUrl();
        this.isSandbox = context.isSandbox();
        this.sandboxAccount = context.getSandboxAccount();
        log.trace("Creando BindApiConnector con {}", (Object)context);
        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getBaseUrl(), context.getKeyStorePath(), context.getKeyStorePassword(), null, null);
        this.connector = new RestConnector(environment, (RestSecurityManager)this);
    }

    public Account[] getAccounts(String bankId, String viewId) throws RestConnectorException {
        String path = "/banks/" + bankId + "/accounts/" + viewId;
        log.debug("[getAccounts] Listando cuentas con path [{}]", (Object)path);
        return (Account[])this.connector.genericGet(null, Account[].class, CommonError.class, path);
    }

    public GetConsultaCuentaPorAliasCbuCvuResponse getAccountAlias(String alias) throws RestConnectorException {
        String path = "/accounts/alias/" + alias;
        log.debug("[getAccountAlias] Consultando cuenta por alias con path [{}]", (Object)path);
        return (GetConsultaCuentaPorAliasCbuCvuResponse)this.connector.genericGet(null, GetConsultaCuentaPorAliasCbuCvuResponse.class, CommonError.class, path);
    }

    public GetConsultaCuentaPorAliasCbuCvuResponse getAccountCbuCvu(String cbu) throws RestConnectorException {
        String path = "/accounts/cbu/" + cbu;
        log.debug("[getAccountCbuCvu] Consultando cuenta por CBU/CVU con path [{}]", (Object)path);
        return (GetConsultaCuentaPorAliasCbuCvuResponse)this.connector.genericGet(null, GetConsultaCuentaPorAliasCbuCvuResponse.class, CommonError.class, path);
    }

    public PostCrearPedidoDebinResponse postCrearPedidoDebinResponse(String bankId, String accountId, String viewId, PostCrearPedidoDebinRequest postCrearPedidoDebinRequest) throws RestConnectorException {
        accountId = this.resolveAccount(accountId);
        String path = "/banks/" + bankId + "/accounts/" + accountId + "/" + viewId + "/transaction-request-types/DEBIN/transaction-requests";
        log.debug("[postCrearPedidoDebinResponse] Creando pedido Debin con path [{}] y [{}]", (Object)path, (Object)postCrearPedidoDebinRequest);
        return (PostCrearPedidoDebinResponse)this.connector.genericPost((Object)postCrearPedidoDebinRequest, PostCrearPedidoDebinResponse.class, CommonError.class, path);
    }

    public GetConsultaDatosVendedorResponse getConsultaDatosVendedorResponse(String bankId, String accountId, String viewId) throws RestConnectorException {
        accountId = this.resolveAccount(accountId);
        String path = "/banks/" + bankId + "/accounts/" + accountId + "/" + viewId + "/transaction-request-types/DEBIN/info";
        log.debug("[getConsultaDatosVendedorResponse] Consultando datos de vendedor Debin con path [{}]", (Object)path);
        return (GetConsultaDatosVendedorResponse)this.connector.genericGet(null, GetConsultaDatosVendedorResponse.class, CommonError.class, path);
    }

    public Transaction[] getObtenerDebinesParaCobrar(String bankId, String accountId, String viewId) throws RestConnectorException {
        accountId = this.resolveAccount(accountId);
        String path = "/banks/" + bankId + "/accounts/" + accountId + "/" + viewId + "/transaction-request-types/DEBIN";
        log.debug("[getObtenerDebinesParaCobrar] Obteniendo Debines para cobrar con path [{}]", (Object)path);
        return (Transaction[])this.connector.genericGet(null, Transaction[].class, CommonError.class, path);
    }

    public Transaction getObtenerDebin(String bankId, String accountId, String viewId, String transactioId) throws RestConnectorException {
        accountId = this.resolveAccount(accountId);
        String path = "/banks/" + bankId + "/accounts/" + accountId + "/" + viewId + "/transaction-request-types/DEBIN/" + transactioId;
        log.debug("[getObtenerDebin] Obteniendo Debin con path [{}]", (Object)path);
        return (Transaction)this.connector.genericGet(null, Transaction.class, CommonError.class, path);
    }

    public DeleteEliminarPedidoDebinResponse deleteEliminarPedidoDebinResponse(String bankId, String accountId, String viewId, String transactioId) throws RestConnectorException {
        accountId = this.resolveAccount(accountId);
        String path = "/banks/" + bankId + "/accounts/" + accountId + "/" + viewId + "/transaction-request-types/DEBIN/" + transactioId;
        log.debug("[deleteEliminarPedidoDebinResponse] Eliminando pedido Debin con path [{}]", (Object)path);
        return (DeleteEliminarPedidoDebinResponse)this.connector.genericDelete(null, DeleteEliminarPedidoDebinResponse.class, CommonError.class, path);
    }

    public PutAltaBajaCuentaVendedorResponse putAltaBajaCuentaVendedorResponse(String bankId, String accountId, String viewId, PutAltaBajaCuentaVendedorRequest putAltaBajaCuentaVendedorRequest) throws RestConnectorException {
        accountId = this.resolveAccount(accountId);
        String path = "/banks/" + bankId + "/accounts/" + accountId + "/" + viewId + "/transaction-request-types/DEBIN/";
        log.debug("[putAltaBajaCuentaVendedorResponse] Dando alta/baja cuenta vendedor Debin con path [{}] y [{}]", (Object)path, (Object)putAltaBajaCuentaVendedorRequest);
        return (PutAltaBajaCuentaVendedorResponse)this.connector.genericPut((Object)putAltaBajaCuentaVendedorRequest, PutAltaBajaCuentaVendedorResponse.class, CommonError.class, path);
    }

    public Transaction postABMPedidoDeRecurrenciaDeDebinResponse(String bankId, String viewId, PostABMPedidoDeRecurrenciaDeDebinRequest postABMPedidoDeRecurrenciaDeDebinRequest) throws RestConnectorException {
        String path = "/banks/" + bankId + "/" + viewId + "/transaction-request-types/DEBIN-SUBSCRIPTION/transaction-requests";
        log.debug("[postABMPedidoDeRecurrenciaDeDebinResponse] Creando pedido de recurrencia Debin con path [{}] y [{}]", (Object)path, (Object)postABMPedidoDeRecurrenciaDeDebinRequest);
        return (Transaction)this.connector.genericPost((Object)postABMPedidoDeRecurrenciaDeDebinRequest, Transaction.class, CommonError.class, path);
    }

    public PostAltaCVUClienteResponse postAltaCVUClienteResponse(String bankId, String accountId, String viewId, PostAltaCVUClienteRequest postAltaCVUClienteRequest) throws RestConnectorException {
        accountId = this.resolveAccount(accountId);
        String path = "/banks/" + bankId + "/accounts/" + accountId + "/" + viewId + "/wallet/cvu";
        log.debug("[postAltaCVUClienteResponse] Creando CVU cliente con path [{}] y [{}]", (Object)path, (Object)postAltaCVUClienteRequest);
        return (PostAltaCVUClienteResponse)this.connector.genericPost((Object)postAltaCVUClienteRequest, PostAltaCVUClienteResponse.class, CommonError.class, path);
    }

    public PostAsignarModificarAliasCVUResponse postAsignarModificarAliasCVUResponse(String bankId, String accountId, String viewId, PostAsignarModificarAliasCVURequest postAsignarModificarAliasCVURequest) throws RestConnectorException {
        accountId = this.resolveAccount(accountId);
        String path = "/banks/" + bankId + "/accounts/" + accountId + "/" + viewId + "/wallet/alias";
        log.debug("[postAsignarModificarAliasCVUResponse] Asignando/modificando alias CVU con path [{}] y [{}]", (Object)path, (Object)postAsignarModificarAliasCVURequest);
        return (PostAsignarModificarAliasCVUResponse)this.connector.genericPost((Object)postAsignarModificarAliasCVURequest, PostAsignarModificarAliasCVUResponse.class, CommonError.class, path);
    }

    public Transaction postRealizarTransferenciaDesdeCVU(String bankId, String accountId, String viewId, PostRealizarTransferenciaDesdeCVURequest postRealizarTransferenciaDesdeCVURequest) throws RestConnectorException {
        accountId = this.resolveAccount(accountId);
        String path = "/banks/" + bankId + "/accounts/" + accountId + "/" + viewId + "/transaction-request-types/TRANSFER-CVU/transaction-requests";
        log.debug("[postRealizarTransferenciaDesdeCVUResponse] Realizando transferencia desde CVU con path [{}] y [{}]", (Object)path, (Object)postRealizarTransferenciaDesdeCVURequest);
        return (Transaction)this.connector.genericPost((Object)postRealizarTransferenciaDesdeCVURequest, Transaction.class, CommonError.class, path);
    }

    public Transaction[] getObtenerListadoDeTransferencias(String bankId, String accountId, String viewId, Date filterFrom, Date filterTo, String filterOrigin, String filterStatus, int offset, int limit) throws RestConnectorException {
        accountId = this.resolveAccount(accountId);
        String path = "/banks/" + bankId + "/accounts/" + accountId + "/" + viewId + "/transaction-request-types/TRANSFER-CVU";
        log.debug("[getObtenerListadoDeTransferencias] Obteniendo listado de transferencias con path [{}]", (Object)path);
        if (filterFrom != null) {
            this.headers.put("obp_from_date", DateUtil.formatJsonDate((Date)filterFrom));
        }
        if (filterTo != null) {
            this.headers.put("obp_to_date", DateUtil.formatJsonDate((Date)filterTo));
        }
        if (filterOrigin != null) {
            this.headers.put("obp_origin", filterOrigin);
        }
        if (filterStatus != null) {
            this.headers.put("obp_status", filterStatus);
        }
        this.headers.put("obp_offset", offset);
        this.headers.put("obp_limit", limit);
        Transaction[] transactions = (Transaction[])this.connector.genericGet(null, Transaction[].class, CommonError.class, path);
        this.headers.clear();
        return transactions;
    }

    public Transaction getObtenerTransferencia(String bankId, String accountId, String viewId, String transactionId) throws RestConnectorException {
        accountId = this.resolveAccount(accountId);
        String path = "/banks/" + bankId + "/accounts/" + accountId + "/" + viewId + "/transaction-request-types/TRANSFER-CVU/" + transactionId;
        log.debug("[getObtenerTransferencialong] Obteniendo transferencia con path [{}]", (Object)path);
        return (Transaction)this.connector.genericGet(null, Transaction.class, CommonError.class, path);
    }

    public DeleteBajaCVUResponse deleteBajaCVUResponse(String bankId, String accountId, String viewId, String cvu, String cuit) throws RestConnectorException {
        accountId = this.resolveAccount(accountId);
        String path = "/banks/" + bankId + "/accounts/" + accountId + "/" + viewId + "/wallet/cvu/" + cvu + "/" + cuit;
        log.debug("[DeleteBajaCVU] Dando de baja CVU con path [{}]", (Object)path);
        return (DeleteBajaCVUResponse)this.connector.genericDelete(null, DeleteBajaCVUResponse.class, CommonError.class, path);
    }

    public PutModificarCVUClienteResponse putModificarCVUCliente(String bankId, String accountId, String viewId, String cvu, PutModificarCVUClienteRequest putModificarCVUClienteRequest) throws RestConnectorException {
        accountId = this.resolveAccount(accountId);
        String path = "/banks/" + bankId + "/accounts/" + accountId + "/" + viewId + "/wallet/cvu/" + cvu;
        log.debug("[putModificarCVUCliente] Modificando CVU cliente con path [{}] y [{}]", (Object)path, (Object)putModificarCVUClienteRequest);
        return (PutModificarCVUClienteResponse)this.connector.genericPut((Object)putModificarCVUClienteRequest, PutModificarCVUClienteResponse.class, CommonError.class, path);
    }

    public PostEmitirChequeResponse postEmitirChequeResponse(String bankId, String accountId, String viewId, PostEmitirChequeRequest postEmitirChequeRequest) throws RestConnectorException {
        accountId = this.resolveAccount(accountId);
        String path = "/banks/" + bankId + "/accounts/" + accountId + "/" + viewId + "/transaction-request-types/CHECK";
        log.debug("[postEmitirCheque] Emitiendo cheque con path [{}] y [{}]", (Object)path, (Object)postEmitirChequeRequest);
        return (PostEmitirChequeResponse)this.connector.genericPost((Object)postEmitirChequeRequest, PostEmitirChequeResponse.class, CommonError.class, path);
    }

    public PutGestionarChequeResponse putGestionarChequeResponse(String bankId, String accountId, String viewId, PutGestionarChequeRequest putGestionarChequeRequest) throws RestConnectorException {
        accountId = this.resolveAccount(accountId);
        String path = "/banks/" + bankId + "/accounts/" + accountId + "/" + viewId + "/transaction-request-types/CHECK";
        log.debug("[putGestionarChequeResponse] Gestionando cheque con path [{}] y [{}]", (Object)path, (Object)putGestionarChequeRequest);
        return (PutGestionarChequeResponse)this.connector.genericPut((Object)putGestionarChequeRequest, PutGestionarChequeResponse.class, CommonError.class, path);
    }

    public GetInformaNovedadesDeEcheqs getInformaNovedadesDeEcheqsResponse(String bankId, String viewId) throws RestConnectorException {
        String path = "/banks/" + bankId + "/echeq/" + viewId + "/notification";
        log.debug("[getInformaNovedadesDeEcheqsResponse] Obteniendo novedades de Echeqs con path [{}]", (Object)path);
        return (GetInformaNovedadesDeEcheqs)this.connector.genericGet(null, GetInformaNovedadesDeEcheqs.class, CommonError.class, path);
    }

    public Transaction[] getObtenerCheques(String bankId, String accountId, String viewId, String filterStatus) throws RestConnectorException {
        accountId = this.resolveAccount(accountId);
        String path = "/banks/" + bankId + "/accounts/" + accountId + "/" + viewId + "/transaction-request-types/CHECK";
        log.debug("[getObtenerCheques] Obteniendo cheques con path [{}]", (Object)path);
        this.headers.put("obp_status", Objects.requireNonNullElse(filterStatus, "ISSUED_PENDING"));
        Transaction[] transactions = (Transaction[])this.connector.genericGet(null, Transaction[].class, CommonError.class, path);
        this.headers.clear();
        return transactions;
    }

    public Transaction getObtenerCheque(String bankId, String accountId, String viewId, String id) throws RestConnectorException {
        accountId = this.resolveAccount(accountId);
        String path = "/banks/" + bankId + "/accounts/" + accountId + "/" + viewId + "/transaction-request-types/CHECK/" + id;
        log.debug("[getObtenerCheque] Obteniendo cheque con path [{}]", (Object)path);
        return (Transaction)this.connector.genericGet(null, Transaction.class, CommonError.class, path);
    }

    public PostAltaModificacionWebhookResponse[] postAltaModificacionWebhookResponses(PostAltaModificacionWebhookRequest postAltaModificacionWebhookRequest) throws RestConnectorException {
        String path = "/webhookds";
        log.debug("[postAltaModificacionWebhookResponses] Dando de alta/modificando webhook con path [{}] y [{}]", (Object)"/webhookds", (Object)postAltaModificacionWebhookRequest);
        return (PostAltaModificacionWebhookResponse[])this.connector.genericPost((Object)postAltaModificacionWebhookRequest, PostAltaModificacionWebhookResponse[].class, CommonError.class, "/webhookds");
    }

    public GetListadoWebhooksResponse[] getListadoWebhooksResponse() throws RestConnectorException {
        String path = "/webhooks";
        log.debug("[getListadoWebhooksResponse] Obteniendo listado de webhooks con path [{}]", (Object)"/webhooks");
        return (GetListadoWebhooksResponse[])this.connector.genericGet(null, GetListadoWebhooksResponse[].class, CommonError.class, "/webhooks");
    }

    public DeleteEliminarWebhookResponse deleteEliminarWebhookResponse(String code) throws RestConnectorException {
        String path = "/webhooks/code/" + code;
        log.debug("[deleteEliminarWebhookResponse] Eliminando webhook con path [{}]", (Object)path);
        return (DeleteEliminarWebhookResponse)this.connector.genericDelete(null, DeleteEliminarWebhookResponse.class, CommonError.class, path);
    }

    public PostEnvioMensajeWebhookConfiguradoResponse postEnvioMensajeWebhookConfiguradoResponse(PostEnvioMensajeWebhookConfiguradoRequest postEnvioMensajeWebhookConfiguradoRequest) throws RestConnectorException {
        String path = "/webhooks/testSendMessage";
        log.debug("[postEnvioMensajeWebhookConfiguradoResponse] Enviando mensaje de prueba a webhook con path [{}]", (Object)"/webhooks/testSendMessage");
        return (PostEnvioMensajeWebhookConfiguradoResponse)this.connector.genericPost((Object)postEnvioMensajeWebhookConfiguradoRequest, PostEnvioMensajeWebhookConfiguradoResponse.class, CommonError.class, "/webhooks/testSendMessage");
    }

    public String resolveAccount(String accountId) {
        if (this.isSandbox) {
            log.info("Usando cuenta sandbox [{}] en lugar de cuenta real [{}]", (Object)this.sandboxAccount, (Object)accountId);
            return this.sandboxAccount;
        }
        return accountId;
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        if (builder != null) {
            if (!this.doingLogin) {
                builder.header("Authorization", (Object)("JWT " + this.getJWTToken(false)));
            }
            if (!this.headers.isEmpty()) {
                for (String headerKey : this.headers.keySet()) {
                    builder.header(headerKey, this.headers.get(headerKey));
                }
            }
        }
        return builder;
    }

    public boolean retryOnUnauthorized() {
        if (!this.doingLogin) {
            try {
                this.getJWTToken(true);
                return true;
            }
            catch (RestConnectorException e) {
                log.error((Object)e);
                return false;
            }
        }
        return false;
    }

    public boolean getDisableHTTPSErrors() {
        return false;
    }

    public String getJWTToken(boolean force) throws RestConnectorException {
        SimpleCache cache = SimpleCacheManager.getInstance().getCache(BindApiConnector.class.getName());
        String cacheKey = SimpleCacheManager.buildKey((Object[])new Object[]{"jwtToken"});
        String jwtToken = (String)cache.get(cacheKey);
        if (force || jwtToken == null) {
            log.debug("[getJWTToken] Obteniendo token con username [{}]", (Object)this.username);
            PostLoginRequest request = new PostLoginRequest(this.username, this.password);
            log.debug("[getJWTToken] Por hacer login con {}", (Object)request);
            this.doingLogin = true;
            PostLoginResponse postLoginResponse = (PostLoginResponse)this.connector.genericPost((Object)request, PostLoginResponse.class, CommonError.class, "/login/jwt");
            this.doingLogin = false;
            jwtToken = postLoginResponse.getToken();
            log.debug("[getJWTToken] Token recuperado [{}], expira en [{}] segs", (Object)jwtToken, (Object)(postLoginResponse.getExpiresIn() - 10));
            cache.put(cacheKey, (Object)jwtToken, Integer.valueOf(postLoginResponse.getExpiresIn() - 10));
        }
        return jwtToken;
    }
}

