package ar.com.sdd.claroapi.model

import com.fasterxml.jackson.annotation.JsonFormat
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import com.fasterxml.jackson.annotation.JsonProperty
import java.math.BigDecimal
import java.util.*

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
open class Cliente {

    @JsonProperty("NUMERO_CLIENTE")
    var numeroCliente: String? = null

    @JsonProperty("STATUS")
    var status: String? = null

    @JsonProperty("CUIT")
    var cuit: String? = null

    @JsonProperty("RAZON_SOCIAL")
    var razonSocial: String? = null

    @JsonProperty("DIRECCION")
    var direccion: String? = null

    @JsonProperty("EMAIL")
    var email: String? = null

    override fun toString(): String {
        return "Cliente(numeroCliente=$numeroCliente, status=$status, cuit=$cuit, razonSocial=$razonSocial, direccion=$direccion, email=$email)"
    }

}