package ar.com.sdd.claroapi.io

import ar.com.sdd.claroapi.model.Pedido
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import com.fasterxml.jackson.annotation.JsonProperty

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
open class ConsultaDeudaAgentesResponse {

    @JsonProperty("ESTADO")
    var estado: String? = null

    @JsonProperty("MENSAJE")
    var mensaje: String? = null

    @JsonProperty("PEDIDOS")
    var pedidos: List<Pedido>? = null


    override fun toString(): String {
        return "ConsultaDeudaAgentesResponse(estado=$estado, mensaje=$mensaje, pedidos=$pedidos)"
    }

}