package ar.com.sdd.claroapi.model

import com.fasterxml.jackson.annotation.JsonFormat
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import com.fasterxml.jackson.annotation.JsonProperty
import java.math.BigDecimal
import java.util.*

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
open class Pedido {

    @JsonProperty("TIPO_PED")
    var tipoPedido: String? = null

    @JsonProperty("NRO_PED")
    var numeroPedido: String? = null

    @JsonProperty("FECHA")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "dd/MM/yyyy")
    var fecha: Date? = null

    @JsonProperty("IMPORTE")
    var importe: BigDecimal? = null

    @JsonProperty("MONEDA")
    var moneda: String? = null

    override fun toString(): String {
        return "Pedido(tipoPedido=$tipoPedido, numeroPedido=$numeroPedido, fecha=$fecha, importe=$importe, moneda=$moneda)"
    }
}