package ar.com.sdd.claroapi.io

import com.fasterxml.jackson.annotation.JsonFormat
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import com.fasterxml.jackson.annotation.JsonProperty
import java.math.BigDecimal
import java.util.*

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
open class ProcesarCobranzaAgentesRequest {

    @JsonProperty("NRO_CLIENTE")
    var nroCliente: String? = null

    @JsonProperty("NRO_PEDIDO")
    var nroPedido: String? = null

    @JsonProperty("FECHA_COBRO")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "dd-MM-yyyy")
    var fechaCobro: Date? = null

    @JsonProperty("NRO_ID_PAGO")
    var nroIdPago: String? = null

    @JsonProperty("NRO_TRANSFERENCIA")
    var nroTransferencia: String? = null

    @JsonProperty("IMPORTE")
    var importe: BigDecimal? = null

    @JsonProperty("MONEDA")
    var moneda: String? = null


    override fun toString(): String {
        return "ProcesarCobranzaAgentesRequest(nroCliente=$nroCliente, nroPedido=$nroPedido, fechaCobro=$fechaCobro, nroIdPago=$nroIdPago, nroTransferencia=$nroTransferencia, importe=$importe, moneda=$moneda)"
    }

}