package ar.com.sdd.claroapi.core

import ar.com.sdd.claroapi.io.ConsultaClientesAgentesResponse
import ar.com.sdd.claroapi.io.ConsultaDeudaAgentesResponse
import ar.com.sdd.claroapi.io.ProcesarCobranzaAgentesRequest
import ar.com.sdd.claroapi.io.ProcesarCobranzaAgentesResponse
import ar.com.sdd.commons.rest.core.RestConnector
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment
import ar.com.sdd.commons.rest.core.RestSecurityManager
import ar.com.sdd.commons.rest.util.QueryBuilder
import ar.com.sdd.commons.rest.util.RestConnectorUtil
import org.apache.log4j.Logger
import javax.ws.rs.client.Invocation

open class ClaroApiConnector(context: ClaroApiConnectorContext) : RestSecurityManager {

    private val log: Logger = Logger.getLogger(ClaroApiConnector::class.java)

    private val restConnector: RestConnector
    private val username: String
    private val password: String

    init {
        username = context.getClaroApiUsername()
        password = context.getClaroApiPassword()

        log.debug("Creando ClaroApiConnector para url [${context.getClaroApiBaseUrl()}], username [$username], password [$password]")

        val environment = RestConnectorEnvironment(context.getClaroApiBaseUrl())
        restConnector = RestConnector(environment, this)
    }


    fun consultaDeudaAgentes(nroCliente: String): ConsultaDeudaAgentesResponse {
        val queryBuilder: QueryBuilder = QueryBuilder.Builder().path("/PublicaDeuda")
            .add("cliente", nroCliente)

        val path = queryBuilder.build()
        log.debug("[consultaDeudaAgentes] Request GET deuda agentes con nroCliente [$nroCliente], path [$path]")
        val response = restConnector.genericGet(null, ConsultaDeudaAgentesResponse::class.java, path)
        log.debug("[consultaDeudaAgentes] Response GET deuda agentes [$response]")

        return response
    }

    fun consultaClientesAgentes(): ConsultaClientesAgentesResponse {
        val path = "/PublicarRecaudadoresVirtuales"
        log.debug("[consultaClientesAgentes] Request GET clientes agentes, path [$path]")
        val response = restConnector.genericGet(null, ConsultaClientesAgentesResponse::class.java, path)
        log.debug("[consultaClientesAgentes] Response GET clientes agentes [$response]")

        return response
    }

    fun procesarCobranza(request: ProcesarCobranzaAgentesRequest): ProcesarCobranzaAgentesResponse {
        val path = "/ProcesarCobranza"
        log.debug("[procesarCobranza] Request POST procesar cobranza, request [$request] path [$path]")
        val response = restConnector.genericPost(request, ProcesarCobranzaAgentesResponse::class.java, path)
        log.debug("[procesarCobranza] Response POST procesar cobranza [$response]")
        return response
    }

    override fun addHeaders(builder: Invocation.Builder?): Invocation.Builder? {
        builder?.header("Authorization", RestConnectorUtil.getBasicAuthHeader(username, password))
        return builder
    }

    override fun getDisableHTTPSErrors(): Boolean {
        return false;
    }
}