/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.rest.core;

import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.SecurityManager;
import ar.com.sdd.commons.rest.log.ClientLoggingFilter;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;

public class RestConnector {
    private static final Logger log = Logger.getLogger(RestConnector.class);
    private String baseUrl;
    private SecurityManager securityManager;
    private ClientLoggingFilter clientLoggingFilter;

    public RestConnector(String baseUrl, SecurityManager securityManager) {
        this.baseUrl = baseUrl;
        this.securityManager = securityManager;
        this.clientLoggingFilter = new ClientLoggingFilter();
    }

    public <Res, Req> Res genericGet(Req request, Class<Res> responseType, String path) throws RestConnectorException {
        return this.genericGet(request, responseType, path, null);
    }

    public <Res, Req> Res genericGet(Req request, Class<Res> responseType, String path, String templateKey, String templateValue) throws RestConnectorException {
        HashMap<String, Object> templateParameters = new HashMap<String, Object>();
        templateParameters.put(templateKey, templateValue);
        return this.genericGet(request, responseType, path, templateParameters);
    }

    private <Res, Req> Res genericGet(Req request, Class<Res> responseType, String path, Map<String, Object> templateParameters) throws RestConnectorException {
        log.trace((Object)("Get cliente request [" + request + "]"));
        try {
            Object entityResponse;
            WebTarget resource = ClientBuilder.newClient().target(this.baseUrl + path);
            resource.register((Object)this.clientLoggingFilter);
            if (templateParameters != null) {
                resource = resource.resolveTemplates(templateParameters);
            }
            Response getResponse = this.securityManager.requestWithHeaders(resource).accept(new String[]{"application/json"}).get();
            log.trace((Object)("Get cliente response [" + getResponse.getStatus() + "/" + getResponse.getStatusInfo() + "]"));
            if (getResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                throw new RestConnectorException("La consulta no devolvio OK. Status: [" + getResponse.getStatus() + "/" + getResponse.getStatusInfo() + "]");
            }
            if (getResponse.getEntity() == null && responseType == Void.class) {
                entityResponse = null;
                log.trace((Object)"Entity response [vacio]");
            } else {
                entityResponse = getResponse.readEntity(responseType);
                log.trace((Object)("Entity response [" + entityResponse + "]"));
            }
            getResponse.close();
            return (Res)entityResponse;
        }
        catch (ProcessingException e) {
            throw new RestConnectorException("Error de comunicaciones", e);
        }
    }

    public <Res, Req> Res genericPost(Req request, Class<Res> responseType, String path) throws RestConnectorException {
        log.trace((Object)("Post cliente request [" + request + "]"));
        try {
            Object entityResponse;
            WebTarget resource = ClientBuilder.newClient().target(this.baseUrl + path);
            resource.register((Object)this.clientLoggingFilter);
            Response postResponse = this.securityManager.requestWithHeaders(resource).accept(new String[]{"application/json"}).post(Entity.entity(request, (String)"application/json"));
            log.trace((Object)("Post cliente response [" + postResponse.getStatus() + "/" + postResponse.getStatusInfo() + "]"));
            if (postResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                throw new RestConnectorException("La consulta no devolvio OK. Status: [" + postResponse.getStatus() + "/" + postResponse.getStatusInfo() + "]");
            }
            if (postResponse.getEntity() == null && responseType == Void.class) {
                entityResponse = null;
                log.trace((Object)"Entity response [vacio]");
            } else {
                entityResponse = postResponse.readEntity(responseType);
                log.trace((Object)("Entity response [" + entityResponse + "]"));
            }
            postResponse.close();
            return (Res)entityResponse;
        }
        catch (ProcessingException e) {
            throw new RestConnectorException("Error de comunicaciones", e);
        }
    }

    public <Res, Req> Res genericDelete(Req request, Class<Res> responseType, String path, Map<String, Object> templateParameters) throws RestConnectorException {
        log.trace((Object)("Delete cliente request [" + request + "]"));
        try {
            WebTarget resource = ClientBuilder.newClient().target(this.baseUrl + path);
            resource.register((Object)this.clientLoggingFilter);
            if (templateParameters != null) {
                resource = resource.resolveTemplates(templateParameters);
            }
            Response deleteResponse = this.securityManager.requestWithHeaders(resource).accept(new String[]{"application/json"}).delete();
            log.trace((Object)("Delete cliente response [" + deleteResponse.getStatus() + "/" + deleteResponse.getStatusInfo() + "]"));
            if (deleteResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                throw new RestConnectorException("La consulta no devolvio OK. Status: [" + deleteResponse.getStatus() + "/" + deleteResponse.getStatusInfo() + "]");
            }
            Object entityResponse = deleteResponse.readEntity(responseType);
            log.trace((Object)("Entity response [" + entityResponse + "]"));
            deleteResponse.close();
            return (Res)entityResponse;
        }
        catch (ProcessingException e) {
            throw new RestConnectorException("Error de comunicaciones", e);
        }
    }
}

