/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.rest.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class RestConnectorUtil {
    public static final int MAX_ENTITY_SIZE = 8192;

    public static String getCacheSafeValue() {
        long ts = System.currentTimeMillis();
        return Long.toString(ts, 36);
    }

    public static File getLogFile(String timestamp36, String serverClientTag, String requestResponseTag) throws IOException {
        String date = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd-HHmmss-SSS");
        String logFilename = "restconnector_" + serverClientTag + "_" + date + "_" + requestResponseTag + "_" + timestamp36 + ".log";
        return new File(FilenameUtils.concat((String)RestConnectorUtil.getLogDirectory(), (String)logFilename));
    }

    public static String getLogDirectory() throws IOException {
        boolean result;
        String jbossLogDir = System.getProperty("jboss.server.log.dir");
        Path path = Paths.get(jbossLogDir, "io");
        File logDirectory = new File(path.toUri());
        if (!logDirectory.exists() && !(result = logDirectory.mkdirs())) {
            throw new IOException("No se pudo crear el directorio de log [" + logDirectory + "]");
        }
        return logDirectory.getAbsolutePath();
    }
}

