package ar.com.sdd.commons.rest.core;

public class RestConnectorEnvironment {

    /**
     * URL base de la API
     */
    public String baseUrl;

    /**
     * Path al KeyStore de certificados privados (nuestros)
     */
    public String keyStorePath;

    /**
     * Password para la keyStore de certificados privados
     */
    public String keyStorePassword;

    /**
     * Path al KeyStore de certificados publicos (ellos)
     */
    public String trustStorePath;


    /**
     * Password para la keyStore de certificados publicos
     */
    public String trustStorePassword;

    public RestConnectorEnvironment() {

    }

    public RestConnectorEnvironment(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public RestConnectorEnvironment(String baseUrl, String keyStorePath, String keyStorePassword, String trustStorePath, String trustStorePassword) {
        this.baseUrl = baseUrl;
        this.keyStorePath = keyStorePath;
        this.keyStorePassword = keyStorePassword;
        this.trustStorePath = trustStorePath;
        this.trustStorePassword = trustStorePassword;
    }

    @Override
    public String toString() {
        return "RestConnectorEnvironment [" +
                "baseUrl=" + baseUrl +
                ", keyStorePath=" + keyStorePath +
                ", keyStorePassword=" + keyStorePassword +
                ", trustStorePath=" + trustStorePath +
                ", trustStorePassword=" + trustStorePassword +
                ']';
    }
}
