/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.rest.core;

import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.rest.log.ClientLoggingFilter;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class RestConnector {
    private static final Logger log = Logger.getLogger(RestConnector.class);
    private RestConnectorEnvironment environment;
    private RestSecurityManager securityManager;
    private KeyStore keyStore;
    private KeyStore trustStore;
    private ClientLoggingFilter clientLoggingFilter;

    public RestConnector(RestConnectorEnvironment environment, RestSecurityManager securityManager) {
        this.environment = environment;
        this.securityManager = securityManager;
        if (!StringUtils.isEmpty((CharSequence)environment.keyStorePath)) {
            try {
                this.keyStore = this.loadStore(environment.keyStorePath, environment.keyStorePassword);
            }
            catch (Exception e) {
                log.error((Object)("No se pudo cargar el keystore de [" + environment.keyStorePath + "] con password [" + environment.keyStorePassword + "]"), (Throwable)e);
            }
            try {
                this.trustStore = this.loadStore(environment.trustStorePath, environment.trustStorePassword);
            }
            catch (Exception e) {
                log.error((Object)("No se pudo cargar el trustStore de [" + environment.trustStorePath + "] con password [" + environment.trustStorePassword + "]"), (Throwable)e);
            }
        }
        this.clientLoggingFilter = new ClientLoggingFilter();
    }

    public <Res, Req> Res genericGet(Req request, Class<Res> responseType, String path) throws RestConnectorException {
        return this.genericGet(request, responseType, path, null);
    }

    public <Res, Req> Res genericGet(Req request, Class<Res> responseType, String path, String templateKey, String templateValue) throws RestConnectorException {
        HashMap<String, Object> templateParameters = new HashMap<String, Object>();
        templateParameters.put(templateKey, templateValue);
        return this.genericGet(request, responseType, path, templateParameters);
    }

    private <Res, Req> Res genericGet(Req request, Class<Res> responseType, String path, Map<String, Object> templateParameters) throws RestConnectorException {
        log.trace((Object)("[RestConnector] Get cliente request [" + request + "]"));
        try {
            Object entityResponse;
            Response getResponse = this.buildRequest(this.environment.baseUrl + path, templateParameters).accept(new String[]{"application/json"}).get();
            log.trace((Object)("[RestConnector] Get cliente response [" + getResponse.getStatus() + "/" + getResponse.getStatusInfo() + "]"));
            if (getResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                throw new RestConnectorException("La consulta no devolvio OK. Status: [" + getResponse.getStatus() + "/" + getResponse.getStatusInfo() + "]");
            }
            if (getResponse.getEntity() == null && responseType == Void.class) {
                entityResponse = null;
                log.trace((Object)"[RestConnector] Entity response [vacio]");
            } else {
                entityResponse = getResponse.readEntity(responseType);
                log.trace((Object)("[RestConnector] Entity response [" + entityResponse + "]"));
            }
            getResponse.close();
            return (Res)entityResponse;
        }
        catch (ProcessingException e) {
            throw new RestConnectorException("Error de comunicaciones", e);
        }
    }

    public <Res, Req> Res genericPost(Req request, Class<Res> responseType, String path) throws RestConnectorException {
        log.trace((Object)("[RestConnector] Post cliente request [" + request + "]"));
        try {
            Object entityResponse;
            Response postResponse = this.buildRequest(this.environment.baseUrl + path, null).accept(new String[]{"application/json"}).post(Entity.entity(request, (String)"application/json"));
            log.trace((Object)("[RestConnector] Post cliente response [" + postResponse.getStatus() + "/" + postResponse.getStatusInfo() + "]"));
            if (postResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                throw new RestConnectorException("La consulta no devolvio OK. Status: [" + postResponse.getStatus() + "/" + postResponse.getStatusInfo() + "]");
            }
            if (postResponse.getEntity() == null && responseType == Void.class) {
                entityResponse = null;
                log.trace((Object)"[RestConnector] Entity response [vacio]");
            } else {
                entityResponse = postResponse.readEntity(responseType);
                log.trace((Object)("[RestConnector] Entity response [" + entityResponse + "]"));
            }
            postResponse.close();
            return (Res)entityResponse;
        }
        catch (ProcessingException e) {
            throw new RestConnectorException("Error de comunicaciones", e);
        }
    }

    public <Res, Req> Res genericDelete(Req request, Class<Res> responseType, String path, Map<String, Object> templateParameters) throws RestConnectorException {
        log.trace((Object)("[RestConnector] Delete cliente request [" + request + "]"));
        try {
            Response deleteResponse = this.buildRequest(this.environment.baseUrl + path, templateParameters).accept(new String[]{"application/json"}).delete();
            log.trace((Object)("[RestConnector] Delete cliente response [" + deleteResponse.getStatus() + "/" + deleteResponse.getStatusInfo() + "]"));
            if (deleteResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                throw new RestConnectorException("La consulta no devolvio OK. Status: [" + deleteResponse.getStatus() + "/" + deleteResponse.getStatusInfo() + "]");
            }
            Object entityResponse = deleteResponse.readEntity(responseType);
            log.trace((Object)("[RestConnector] Entity response [" + entityResponse + "]"));
            deleteResponse.close();
            return (Res)entityResponse;
        }
        catch (ProcessingException e) {
            throw new RestConnectorException("Error de comunicaciones", e);
        }
    }

    private Invocation.Builder buildRequest(String url, Map<String, Object> templateParameters) throws RestConnectorException {
        ClientBuilder builder = ClientBuilder.newBuilder();
        if (this.keyStore != null) {
            builder.keyStore(this.keyStore, this.environment.keyStorePassword);
        }
        if (this.trustStore != null) {
            builder.trustStore(this.trustStore);
            builder.hostnameVerifier((hostName, session) -> true);
        }
        WebTarget resource = ClientBuilder.newClient().target(url);
        resource.register((Object)this.clientLoggingFilter);
        if (templateParameters != null) {
            resource = resource.resolveTemplates(templateParameters);
        }
        Invocation.Builder request = resource.request();
        if (this.securityManager != null) {
            request = this.securityManager.addHeaders(request);
        }
        return request;
    }

    private KeyStore loadStore(String storePath, String storePassword) throws Exception {
        KeyStore store = KeyStore.getInstance("JKS");
        store.load(new FileInputStream(storePath), storePassword.toCharArray());
        return store;
    }
}

